package org.wildfly.swarm.config.keycloak.secure_deployment;

import org.wildfly.swarm.config.keycloak.secure_deployment.Credential;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface CredentialConsumer<T extends Credential<T>> {

	/**
	 * Configure a pre-constructed instance of Credential resource
	 * 
	 * @parameter Instance of Credential to configure
	 * @return nothing
	 */
	void accept(T value);

	default CredentialConsumer<T> andThen(CredentialConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}