package org.jboss.shrinkwrap.descriptor.impl.jboss51; 

import org.jboss.shrinkwrap.descriptor.api.jboss51.JbossDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.LoaderRepositoryType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.LoaderRepositoryTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.WebservicesType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.WebservicesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.EnterpriseBeansType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.EnterpriseBeansTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.AssemblyDescriptorType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.AssemblyDescriptorTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ResourceManagersType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.ResourceManagersTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.javaee5.IconType;
import org.jboss.shrinkwrap.descriptor.impl.javaee5.IconTypeImpl;
import java.util.Map.Entry;

import org.jboss.shrinkwrap.descriptor.api.DescriptorNamespace;

import org.jboss.shrinkwrap.descriptor.spi.node.NodeDescriptorImplBase;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/** 
 * <p> 
 * This deployment descriptor provides the functionalities as described in the  specification
 * <p> 
 * Example:
 * <p> 
 * <code> 
 *     JbossDescriptor descriptor = Descriptors.create(JbossDescriptor.class);
 * </code> 
 *
 *
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class JbossDescriptorImpl extends NodeDescriptorImplBase implements DescriptorNamespace<JbossDescriptor>, JbossDescriptor
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private Node model;

   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public JbossDescriptorImpl(String descriptorName)
   {
       this(descriptorName, new Node("jboss"));
   }

   public JbossDescriptorImpl(String descriptorName, Node node)
   {
      super(descriptorName);
      this.model = node;
      addDefaultNamespaces();
   }

   // -------------------------------------------------------------------------------------||
   // Methods 
   // -------------------------------------------------------------------------------------||

   public Node getRootNode()
   {
      return model;
   }



   // -------------------------------------------------------------------------------------||
   // Namespace 
   // -------------------------------------------------------------------------------------||


   /**
    * Adds the default namespaces as defined in the specification 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor addDefaultNamespaces()
   {
      addNamespace("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
      addNamespace("xsi:schemaLocation", "http://www.jboss.com/xml/ns/javaee http://www.jboss.org/j2ee/schema/jboss_5_1.xsd");
      addNamespace("xmlns", "http://www.jboss.com/xml/ns/javaee");
     return this;
   }

   /**
    * Adds a new namespace 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor addNamespace(String name, String value)
   {
      model.attribute(name, value);
      return this;
   }

   /**
    * Returns all defined namespaces. 
    * @return all defined namespaces 
    */
   public List<String> getNamespaces()
   {
      List<String> namespaceList = new ArrayList<String>();
      java.util.Map<String, String> attributes = model.getAttributes();
      for (Entry<String, String> e : attributes.entrySet())
      {
         final String name = e.getKey();
         final String value = e.getValue();
         if (value != null && value.startsWith("http://")) 
         {
            namespaceList.add(name + "=" + value);
         }
      }
      return namespaceList;
   }

   /**
    * Removes all existing namespaces. 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeAllNamespaces()
   {
      List<String> nameSpaceKeys = new ArrayList<String>();
      java.util.Map<String, String> attributes = model.getAttributes();
      for (Entry<String, String> e : attributes.entrySet())
      {
         final String name = e.getKey();
         final String value = e.getValue();
         if (value != null && value.startsWith("http://")) 
         {
            nameSpaceKeys.add(name);
         }
      }
      for (String name: nameSpaceKeys)
      {
         model.removeAttribute(name);
      }
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: jboss:loader-repositoryType ElementType : loader-repository
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>loader-repository</code> element with the given value will be created.
    * Otherwise, the existing <code>loader-repository</code> element will be returned.
    * @return  a new or existing instance of <code>LoaderRepositoryType<JbossDescriptor></code> 
    */
   public LoaderRepositoryType<JbossDescriptor> getOrCreateLoaderRepository()
   {
      Node node = model.getOrCreate("loader-repository");
      LoaderRepositoryType<JbossDescriptor> loaderRepository = new LoaderRepositoryTypeImpl<JbossDescriptor>(this, "loader-repository", model, node);
      return loaderRepository;
   }

   /**
    * Removes the <code>loader-repository</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeLoaderRepository()
   {
      model.removeChildren("loader-repository");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: xsd:token ElementType : jmx-name
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>jmx-name</code> element
    * @param jmxName the value for the element <code>jmx-name</code> 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor jmxName(String jmxName)
   {
      model.getOrCreate("jmx-name").text(jmxName);
      return this;
   }

   /**
    * Returns the <code>jmx-name</code> element
    * @return the node defined for the element <code>jmx-name</code> 
    */
   public String getJmxName()
   {
      return model.getTextValueForPatternName("jmx-name");
   }

   /**
    * Removes the <code>jmx-name</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeJmxName()
   {
      model.removeChildren("jmx-name");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: xsd:token ElementType : security-domain
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>security-domain</code> element
    * @param securityDomain the value for the element <code>security-domain</code> 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor securityDomain(String securityDomain)
   {
      model.getOrCreate("security-domain").text(securityDomain);
      return this;
   }

   /**
    * Returns the <code>security-domain</code> element
    * @return the node defined for the element <code>security-domain</code> 
    */
   public String getSecurityDomain()
   {
      return model.getTextValueForPatternName("security-domain");
   }

   /**
    * Removes the <code>security-domain</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeSecurityDomain()
   {
      model.removeChildren("security-domain");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: javaee:true-falseType ElementType : missing-method-permissions-excluded-mode
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>missing-method-permissions-excluded-mode</code> element
    * @param missingMethodPermissionsExcludedMode the value for the element <code>missing-method-permissions-excluded-mode</code> 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor missingMethodPermissionsExcludedMode(String missingMethodPermissionsExcludedMode)
   {
      model.getOrCreate("missing-method-permissions-excluded-mode").text(missingMethodPermissionsExcludedMode);
      return this;
   }

   /**
    * Returns the <code>missing-method-permissions-excluded-mode</code> element
    * @return the node defined for the element <code>missing-method-permissions-excluded-mode</code> 
    */
   public String getMissingMethodPermissionsExcludedMode()
   {
      return model.getTextValueForPatternName("missing-method-permissions-excluded-mode");
   }

   /**
    * Removes the <code>missing-method-permissions-excluded-mode</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeMissingMethodPermissionsExcludedMode()
   {
      model.removeChildren("missing-method-permissions-excluded-mode");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: javaee:string ElementType : unauthenticated-principal
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>unauthenticated-principal</code> element
    * @param unauthenticatedPrincipal the value for the element <code>unauthenticated-principal</code> 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor unauthenticatedPrincipal(String unauthenticatedPrincipal)
   {
      model.getOrCreate("unauthenticated-principal").text(unauthenticatedPrincipal);
      return this;
   }

   /**
    * Returns the <code>unauthenticated-principal</code> element
    * @return the node defined for the element <code>unauthenticated-principal</code> 
    */
   public String getUnauthenticatedPrincipal()
   {
      return model.getTextValueForPatternName("unauthenticated-principal");
   }

   /**
    * Removes the <code>unauthenticated-principal</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeUnauthenticatedPrincipal()
   {
      model.removeChildren("unauthenticated-principal");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: xsd:token ElementType : jndi-binding-policy
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>jndi-binding-policy</code> element
    * @param jndiBindingPolicy the value for the element <code>jndi-binding-policy</code> 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor jndiBindingPolicy(String jndiBindingPolicy)
   {
      model.getOrCreate("jndi-binding-policy").text(jndiBindingPolicy);
      return this;
   }

   /**
    * Returns the <code>jndi-binding-policy</code> element
    * @return the node defined for the element <code>jndi-binding-policy</code> 
    */
   public String getJndiBindingPolicy()
   {
      return model.getTextValueForPatternName("jndi-binding-policy");
   }

   /**
    * Removes the <code>jndi-binding-policy</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeJndiBindingPolicy()
   {
      model.removeChildren("jndi-binding-policy");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: javaee:string ElementType : jacc-context-id
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>jacc-context-id</code> element
    * @param jaccContextId the value for the element <code>jacc-context-id</code> 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor jaccContextId(String jaccContextId)
   {
      model.getOrCreate("jacc-context-id").text(jaccContextId);
      return this;
   }

   /**
    * Returns the <code>jacc-context-id</code> element
    * @return the node defined for the element <code>jacc-context-id</code> 
    */
   public String getJaccContextId()
   {
      return model.getTextValueForPatternName("jacc-context-id");
   }

   /**
    * Removes the <code>jacc-context-id</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeJaccContextId()
   {
      model.removeChildren("jacc-context-id");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: jboss:webservicesType ElementType : webservices
   // MaxOccurs: -1  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>webservices</code> element with the given value will be created.
    * Otherwise, the existing <code>webservices</code> element will be returned.
    * @return  a new or existing instance of <code>WebservicesType<JbossDescriptor></code> 
    */
   public WebservicesType<JbossDescriptor> getOrCreateWebservices()
   {
      Node node = model.getOrCreate("webservices");
      WebservicesType<JbossDescriptor> webservices = new WebservicesTypeImpl<JbossDescriptor>(this, "webservices", model, node);
      return webservices;
   }

   /**
    * Removes the <code>webservices</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeWebservices()
   {
      model.removeChildren("webservices");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: jboss:enterprise-beansType ElementType : enterprise-beans
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>enterprise-beans</code> element with the given value will be created.
    * Otherwise, the existing <code>enterprise-beans</code> element will be returned.
    * @return  a new or existing instance of <code>EnterpriseBeansType<JbossDescriptor></code> 
    */
   public EnterpriseBeansType<JbossDescriptor> getOrCreateEnterpriseBeans()
   {
      Node node = model.getOrCreate("enterprise-beans");
      EnterpriseBeansType<JbossDescriptor> enterpriseBeans = new EnterpriseBeansTypeImpl<JbossDescriptor>(this, "enterprise-beans", model, node);
      return enterpriseBeans;
   }

   /**
    * Removes the <code>enterprise-beans</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeEnterpriseBeans()
   {
      model.removeChildren("enterprise-beans");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: jboss:assembly-descriptorType ElementType : assembly-descriptor
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>assembly-descriptor</code> element with the given value will be created.
    * Otherwise, the existing <code>assembly-descriptor</code> element will be returned.
    * @return  a new or existing instance of <code>AssemblyDescriptorType<JbossDescriptor></code> 
    */
   public AssemblyDescriptorType<JbossDescriptor> getOrCreateAssemblyDescriptor()
   {
      Node node = model.getOrCreate("assembly-descriptor");
      AssemblyDescriptorType<JbossDescriptor> assemblyDescriptor = new AssemblyDescriptorTypeImpl<JbossDescriptor>(this, "assembly-descriptor", model, node);
      return assemblyDescriptor;
   }

   /**
    * Removes the <code>assembly-descriptor</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeAssemblyDescriptor()
   {
      model.removeChildren("assembly-descriptor");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: jboss:resource-managersType ElementType : resource-managers
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-managers</code> element with the given value will be created.
    * Otherwise, the existing <code>resource-managers</code> element will be returned.
    * @return  a new or existing instance of <code>ResourceManagersType<JbossDescriptor></code> 
    */
   public ResourceManagersType<JbossDescriptor> getOrCreateResourceManagers()
   {
      Node node = model.getOrCreate("resource-managers");
      ResourceManagersType<JbossDescriptor> resourceManagers = new ResourceManagersTypeImpl<JbossDescriptor>(this, "resource-managers", model, node);
      return resourceManagers;
   }

   /**
    * Removes the <code>resource-managers</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeResourceManagers()
   {
      model.removeChildren("resource-managers");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: xsd:token ElementType : version
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>version</code> attribute
    * @param version the value for the attribute <code>version</code> 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor version(String version)
   {
      model.attribute("version", version);
      return this;
   }

   /**
    * Returns the <code>version</code> attribute
    * @return the value defined for the attribute <code>version</code> 
    */
      public String getVersion()
   {
      return model.getAttribute("version");
   }

   /**
    * Removes the <code>version</code> attribute 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeVersion()
   {
      model.removeAttribute("version");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: xsd:boolean ElementType : metadata-complete
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>metadata-complete</code> attribute
    * @param metadataComplete the value for the attribute <code>metadata-complete</code> 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor metadataComplete(Boolean metadataComplete)
   {
      model.attribute("metadata-complete", metadataComplete);
      return this;
   }

   /**
    * Returns the <code>metadata-complete</code> attribute
    * @return the value defined for the attribute <code>metadata-complete</code> 
    */
   public Boolean isMetadataComplete()
   {
      return Strings.isTrue(model.getAttribute("metadata-complete"));
   }

   /**
    * Removes the <code>metadata-complete</code> attribute 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeMetadataComplete()
   {
      model.removeAttribute("metadata-complete");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor id(String id)
   {
      model.attribute("id", id);
      return this;
   }

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
      public String getId()
   {
      return model.getAttribute("id");
   }

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeId()
   {
      model.removeAttribute("id");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor description(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            model.createChild("description").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
public List<String> getAllDescription()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = model.get("description");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeAllDescription()
   {
      model.removeChildren("description");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: xsd:token ElementType : display-name
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>display-name</code> elements, 
    * a new <code>display-name</code> element 
    * @param values list of <code>display-name</code> objects 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor displayName(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            model.createChild("display-name").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>display-name</code> elements
    * @return list of <code>display-name</code> 
    */
public List<String> getAllDisplayName()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = model.get("display-name");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>display-name</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeAllDisplayName()
   {
      model.removeChildren("display-name");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: javaee:iconType ElementType : icon
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>icon</code> element will be created and returned.
    * Otherwise, the first existing <code>icon</code> element will be returned.
    * @return the instance defined for the element <code>icon</code> 
    */
   public IconType<JbossDescriptor> getOrCreateIcon()
   {
      List<Node> nodeList = model.get("icon");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new IconTypeImpl<JbossDescriptor>(this, "icon", model, nodeList.get(0));
      }
      return createIcon();
   }

   /**
    * Creates a new <code>icon</code> element 
    * @return the new created instance of <code>IconType<JbossDescriptor></code> 
    */
   public IconType<JbossDescriptor> createIcon()
   {
      return new IconTypeImpl<JbossDescriptor>(this, "icon", model);
   }

   /**
    * Returns all <code>icon</code> elements
    * @return list of <code>icon</code> 
    */
   public List<IconType<JbossDescriptor>> getAllIcon()
   {
      List<IconType<JbossDescriptor>> list = new ArrayList<IconType<JbossDescriptor>>();
      List<Node> nodeList = model.get("icon");
      for(Node node: nodeList)
      {
         IconType<JbossDescriptor>  type = new IconTypeImpl<JbossDescriptor>(this, "icon", model, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>icon</code> elements 
    * @return the current instance of <code>IconType<JbossDescriptor></code> 
    */
   public JbossDescriptor removeAllIcon()
   {
      model.removeChildren("icon");
      return this;
   }

}
