package org.jboss.shrinkwrap.descriptor.impl.jboss51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jboss51.MessageDrivenBeanType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ActivationConfigType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.ActivationConfigTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.EjbRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.EjbRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.EjbLocalRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.EjbLocalRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.ServiceRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.ServiceRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.ResourceRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.ResourceRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.ResourceEnvRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.ResourceEnvRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.MessageDestinationRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.MessageDestinationRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.SecurityIdentityType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.SecurityIdentityTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.MethodAttributesType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.MethodAttributesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.SecurityIdentityType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.SecurityIdentityTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.AnnotationType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.AnnotationTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.IgnoreDependencyType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.IgnoreDependencyTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.PoolConfigType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.PoolConfigTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.JndiRefType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.JndiRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.javaee5.IconType;
import org.jboss.shrinkwrap.descriptor.impl.javaee5.IconTypeImpl;

/**
 * This class implements the <code> message-driven-beanType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class MessageDrivenBeanTypeImpl<T> implements Child<T>, MessageDrivenBeanType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public MessageDrivenBeanTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public MessageDrivenBeanTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> description(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("description").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
public List<String> getAllDescription()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("description");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removeAllDescription()
   {
      childNode.removeChildren("description");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: xsd:token ElementType : display-name
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>display-name</code> elements, 
    * a new <code>display-name</code> element 
    * @param values list of <code>display-name</code> objects 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> displayName(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("display-name").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>display-name</code> elements
    * @return list of <code>display-name</code> 
    */
public List<String> getAllDisplayName()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("display-name");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>display-name</code> element 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removeAllDisplayName()
   {
      childNode.removeChildren("display-name");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: javaee:iconType ElementType : icon
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>icon</code> element will be created and returned.
    * Otherwise, the first existing <code>icon</code> element will be returned.
    * @return the instance defined for the element <code>icon</code> 
    */
   public IconType<MessageDrivenBeanType<T>> getOrCreateIcon()
   {
      List<Node> nodeList = childNode.get("icon");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new IconTypeImpl<MessageDrivenBeanType<T>>(this, "icon", childNode, nodeList.get(0));
      }
      return createIcon();
   }

   /**
    * Creates a new <code>icon</code> element 
    * @return the new created instance of <code>IconType<MessageDrivenBeanType<T>></code> 
    */
   public IconType<MessageDrivenBeanType<T>> createIcon()
   {
      return new IconTypeImpl<MessageDrivenBeanType<T>>(this, "icon", childNode);
   }

   /**
    * Returns all <code>icon</code> elements
    * @return list of <code>icon</code> 
    */
   public List<IconType<MessageDrivenBeanType<T>>> getAllIcon()
   {
      List<IconType<MessageDrivenBeanType<T>>> list = new ArrayList<IconType<MessageDrivenBeanType<T>>>();
      List<Node> nodeList = childNode.get("icon");
      for(Node node: nodeList)
      {
         IconType<MessageDrivenBeanType<T>>  type = new IconTypeImpl<MessageDrivenBeanType<T>>(this, "icon", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>icon</code> elements 
    * @return the current instance of <code>IconType<MessageDrivenBeanType<T>></code> 
    */
   public MessageDrivenBeanType<T> removeAllIcon()
   {
      childNode.removeChildren("icon");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: javaee:xsdNMTOKENType ElementType : ejb-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>ejb-name</code> element
    * @param ejbName the value for the element <code>ejb-name</code> 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> ejbName(String ejbName)
   {
      childNode.getOrCreate("ejb-name").text(ejbName);
      return this;
   }

   /**
    * Returns the <code>ejb-name</code> element
    * @return the node defined for the element <code>ejb-name</code> 
    */
   public String getEjbName()
   {
      return childNode.getTextValueForPatternName("ejb-name");
   }

   /**
    * Removes the <code>ejb-name</code> element 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removeEjbName()
   {
      childNode.removeChildren("ejb-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: jboss:activation-configType ElementType : activation-config
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>activation-config</code> element with the given value will be created.
    * Otherwise, the existing <code>activation-config</code> element will be returned.
    * @return  a new or existing instance of <code>ActivationConfigType<MessageDrivenBeanType<T>></code> 
    */
   public ActivationConfigType<MessageDrivenBeanType<T>> getOrCreateActivationConfig()
   {
      Node node = childNode.getOrCreate("activation-config");
      ActivationConfigType<MessageDrivenBeanType<T>> activationConfig = new ActivationConfigTypeImpl<MessageDrivenBeanType<T>>(this, "activation-config", childNode, node);
      return activationConfig;
   }

   /**
    * Removes the <code>activation-config</code> element 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removeActivationConfig()
   {
      childNode.removeChildren("activation-config");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: javaee:string ElementType : destination-jndi-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>destination-jndi-name</code> element
    * @param destinationJndiName the value for the element <code>destination-jndi-name</code> 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> destinationJndiName(String destinationJndiName)
   {
      childNode.getOrCreate("destination-jndi-name").text(destinationJndiName);
      return this;
   }

   /**
    * Returns the <code>destination-jndi-name</code> element
    * @return the node defined for the element <code>destination-jndi-name</code> 
    */
   public String getDestinationJndiName()
   {
      return childNode.getTextValueForPatternName("destination-jndi-name");
   }

   /**
    * Removes the <code>destination-jndi-name</code> element 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removeDestinationJndiName()
   {
      childNode.removeChildren("destination-jndi-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: javaee:string ElementType : mdb-user
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>mdb-user</code> element
    * @param mdbUser the value for the element <code>mdb-user</code> 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> mdbUser(String mdbUser)
   {
      childNode.getOrCreate("mdb-user").text(mdbUser);
      return this;
   }

   /**
    * Returns the <code>mdb-user</code> element
    * @return the node defined for the element <code>mdb-user</code> 
    */
   public String getMdbUser()
   {
      return childNode.getTextValueForPatternName("mdb-user");
   }

   /**
    * Removes the <code>mdb-user</code> element 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removeMdbUser()
   {
      childNode.removeChildren("mdb-user");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: javaee:string ElementType : mdb-passwd
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>mdb-passwd</code> element
    * @param mdbPasswd the value for the element <code>mdb-passwd</code> 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> mdbPasswd(String mdbPasswd)
   {
      childNode.getOrCreate("mdb-passwd").text(mdbPasswd);
      return this;
   }

   /**
    * Returns the <code>mdb-passwd</code> element
    * @return the node defined for the element <code>mdb-passwd</code> 
    */
   public String getMdbPasswd()
   {
      return childNode.getTextValueForPatternName("mdb-passwd");
   }

   /**
    * Removes the <code>mdb-passwd</code> element 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removeMdbPasswd()
   {
      childNode.removeChildren("mdb-passwd");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: javaee:string ElementType : mdb-client-id
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>mdb-client-id</code> element
    * @param mdbClientId the value for the element <code>mdb-client-id</code> 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> mdbClientId(String mdbClientId)
   {
      childNode.getOrCreate("mdb-client-id").text(mdbClientId);
      return this;
   }

   /**
    * Returns the <code>mdb-client-id</code> element
    * @return the node defined for the element <code>mdb-client-id</code> 
    */
   public String getMdbClientId()
   {
      return childNode.getTextValueForPatternName("mdb-client-id");
   }

   /**
    * Removes the <code>mdb-client-id</code> element 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removeMdbClientId()
   {
      childNode.removeChildren("mdb-client-id");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: javaee:string ElementType : mdb-subscription-id
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>mdb-subscription-id</code> element
    * @param mdbSubscriptionId the value for the element <code>mdb-subscription-id</code> 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> mdbSubscriptionId(String mdbSubscriptionId)
   {
      childNode.getOrCreate("mdb-subscription-id").text(mdbSubscriptionId);
      return this;
   }

   /**
    * Returns the <code>mdb-subscription-id</code> element
    * @return the node defined for the element <code>mdb-subscription-id</code> 
    */
   public String getMdbSubscriptionId()
   {
      return childNode.getTextValueForPatternName("mdb-subscription-id");
   }

   /**
    * Removes the <code>mdb-subscription-id</code> element 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removeMdbSubscriptionId()
   {
      childNode.removeChildren("mdb-subscription-id");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: javaee:string ElementType : resource-adapter-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>resource-adapter-name</code> element
    * @param resourceAdapterName the value for the element <code>resource-adapter-name</code> 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> resourceAdapterName(String resourceAdapterName)
   {
      childNode.getOrCreate("resource-adapter-name").text(resourceAdapterName);
      return this;
   }

   /**
    * Returns the <code>resource-adapter-name</code> element
    * @return the node defined for the element <code>resource-adapter-name</code> 
    */
   public String getResourceAdapterName()
   {
      return childNode.getTextValueForPatternName("resource-adapter-name");
   }

   /**
    * Removes the <code>resource-adapter-name</code> element 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removeResourceAdapterName()
   {
      childNode.removeChildren("resource-adapter-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: jboss:ejb-refType ElementType : ejb-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ejb-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>ejb-ref</code> element will be returned.
    * @return the instance defined for the element <code>ejb-ref</code> 
    */
   public EjbRefType<MessageDrivenBeanType<T>> getOrCreateEjbRef()
   {
      List<Node> nodeList = childNode.get("ejb-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new EjbRefTypeImpl<MessageDrivenBeanType<T>>(this, "ejb-ref", childNode, nodeList.get(0));
      }
      return createEjbRef();
   }

   /**
    * Creates a new <code>ejb-ref</code> element 
    * @return the new created instance of <code>EjbRefType<MessageDrivenBeanType<T>></code> 
    */
   public EjbRefType<MessageDrivenBeanType<T>> createEjbRef()
   {
      return new EjbRefTypeImpl<MessageDrivenBeanType<T>>(this, "ejb-ref", childNode);
   }

   /**
    * Returns all <code>ejb-ref</code> elements
    * @return list of <code>ejb-ref</code> 
    */
   public List<EjbRefType<MessageDrivenBeanType<T>>> getAllEjbRef()
   {
      List<EjbRefType<MessageDrivenBeanType<T>>> list = new ArrayList<EjbRefType<MessageDrivenBeanType<T>>>();
      List<Node> nodeList = childNode.get("ejb-ref");
      for(Node node: nodeList)
      {
         EjbRefType<MessageDrivenBeanType<T>>  type = new EjbRefTypeImpl<MessageDrivenBeanType<T>>(this, "ejb-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>ejb-ref</code> elements 
    * @return the current instance of <code>EjbRefType<MessageDrivenBeanType<T>></code> 
    */
   public MessageDrivenBeanType<T> removeAllEjbRef()
   {
      childNode.removeChildren("ejb-ref");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: jboss:ejb-local-refType ElementType : ejb-local-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ejb-local-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>ejb-local-ref</code> element will be returned.
    * @return the instance defined for the element <code>ejb-local-ref</code> 
    */
   public EjbLocalRefType<MessageDrivenBeanType<T>> getOrCreateEjbLocalRef()
   {
      List<Node> nodeList = childNode.get("ejb-local-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new EjbLocalRefTypeImpl<MessageDrivenBeanType<T>>(this, "ejb-local-ref", childNode, nodeList.get(0));
      }
      return createEjbLocalRef();
   }

   /**
    * Creates a new <code>ejb-local-ref</code> element 
    * @return the new created instance of <code>EjbLocalRefType<MessageDrivenBeanType<T>></code> 
    */
   public EjbLocalRefType<MessageDrivenBeanType<T>> createEjbLocalRef()
   {
      return new EjbLocalRefTypeImpl<MessageDrivenBeanType<T>>(this, "ejb-local-ref", childNode);
   }

   /**
    * Returns all <code>ejb-local-ref</code> elements
    * @return list of <code>ejb-local-ref</code> 
    */
   public List<EjbLocalRefType<MessageDrivenBeanType<T>>> getAllEjbLocalRef()
   {
      List<EjbLocalRefType<MessageDrivenBeanType<T>>> list = new ArrayList<EjbLocalRefType<MessageDrivenBeanType<T>>>();
      List<Node> nodeList = childNode.get("ejb-local-ref");
      for(Node node: nodeList)
      {
         EjbLocalRefType<MessageDrivenBeanType<T>>  type = new EjbLocalRefTypeImpl<MessageDrivenBeanType<T>>(this, "ejb-local-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>ejb-local-ref</code> elements 
    * @return the current instance of <code>EjbLocalRefType<MessageDrivenBeanType<T>></code> 
    */
   public MessageDrivenBeanType<T> removeAllEjbLocalRef()
   {
      childNode.removeChildren("ejb-local-ref");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: jboss:service-refType ElementType : service-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>service-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>service-ref</code> element will be returned.
    * @return the instance defined for the element <code>service-ref</code> 
    */
   public ServiceRefType<MessageDrivenBeanType<T>> getOrCreateServiceRef()
   {
      List<Node> nodeList = childNode.get("service-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ServiceRefTypeImpl<MessageDrivenBeanType<T>>(this, "service-ref", childNode, nodeList.get(0));
      }
      return createServiceRef();
   }

   /**
    * Creates a new <code>service-ref</code> element 
    * @return the new created instance of <code>ServiceRefType<MessageDrivenBeanType<T>></code> 
    */
   public ServiceRefType<MessageDrivenBeanType<T>> createServiceRef()
   {
      return new ServiceRefTypeImpl<MessageDrivenBeanType<T>>(this, "service-ref", childNode);
   }

   /**
    * Returns all <code>service-ref</code> elements
    * @return list of <code>service-ref</code> 
    */
   public List<ServiceRefType<MessageDrivenBeanType<T>>> getAllServiceRef()
   {
      List<ServiceRefType<MessageDrivenBeanType<T>>> list = new ArrayList<ServiceRefType<MessageDrivenBeanType<T>>>();
      List<Node> nodeList = childNode.get("service-ref");
      for(Node node: nodeList)
      {
         ServiceRefType<MessageDrivenBeanType<T>>  type = new ServiceRefTypeImpl<MessageDrivenBeanType<T>>(this, "service-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>service-ref</code> elements 
    * @return the current instance of <code>ServiceRefType<MessageDrivenBeanType<T>></code> 
    */
   public MessageDrivenBeanType<T> removeAllServiceRef()
   {
      childNode.removeChildren("service-ref");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: jboss:resource-refType ElementType : resource-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>resource-ref</code> element will be returned.
    * @return the instance defined for the element <code>resource-ref</code> 
    */
   public ResourceRefType<MessageDrivenBeanType<T>> getOrCreateResourceRef()
   {
      List<Node> nodeList = childNode.get("resource-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ResourceRefTypeImpl<MessageDrivenBeanType<T>>(this, "resource-ref", childNode, nodeList.get(0));
      }
      return createResourceRef();
   }

   /**
    * Creates a new <code>resource-ref</code> element 
    * @return the new created instance of <code>ResourceRefType<MessageDrivenBeanType<T>></code> 
    */
   public ResourceRefType<MessageDrivenBeanType<T>> createResourceRef()
   {
      return new ResourceRefTypeImpl<MessageDrivenBeanType<T>>(this, "resource-ref", childNode);
   }

   /**
    * Returns all <code>resource-ref</code> elements
    * @return list of <code>resource-ref</code> 
    */
   public List<ResourceRefType<MessageDrivenBeanType<T>>> getAllResourceRef()
   {
      List<ResourceRefType<MessageDrivenBeanType<T>>> list = new ArrayList<ResourceRefType<MessageDrivenBeanType<T>>>();
      List<Node> nodeList = childNode.get("resource-ref");
      for(Node node: nodeList)
      {
         ResourceRefType<MessageDrivenBeanType<T>>  type = new ResourceRefTypeImpl<MessageDrivenBeanType<T>>(this, "resource-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>resource-ref</code> elements 
    * @return the current instance of <code>ResourceRefType<MessageDrivenBeanType<T>></code> 
    */
   public MessageDrivenBeanType<T> removeAllResourceRef()
   {
      childNode.removeChildren("resource-ref");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: jboss:resource-env-refType ElementType : resource-env-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-env-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>resource-env-ref</code> element will be returned.
    * @return the instance defined for the element <code>resource-env-ref</code> 
    */
   public ResourceEnvRefType<MessageDrivenBeanType<T>> getOrCreateResourceEnvRef()
   {
      List<Node> nodeList = childNode.get("resource-env-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ResourceEnvRefTypeImpl<MessageDrivenBeanType<T>>(this, "resource-env-ref", childNode, nodeList.get(0));
      }
      return createResourceEnvRef();
   }

   /**
    * Creates a new <code>resource-env-ref</code> element 
    * @return the new created instance of <code>ResourceEnvRefType<MessageDrivenBeanType<T>></code> 
    */
   public ResourceEnvRefType<MessageDrivenBeanType<T>> createResourceEnvRef()
   {
      return new ResourceEnvRefTypeImpl<MessageDrivenBeanType<T>>(this, "resource-env-ref", childNode);
   }

   /**
    * Returns all <code>resource-env-ref</code> elements
    * @return list of <code>resource-env-ref</code> 
    */
   public List<ResourceEnvRefType<MessageDrivenBeanType<T>>> getAllResourceEnvRef()
   {
      List<ResourceEnvRefType<MessageDrivenBeanType<T>>> list = new ArrayList<ResourceEnvRefType<MessageDrivenBeanType<T>>>();
      List<Node> nodeList = childNode.get("resource-env-ref");
      for(Node node: nodeList)
      {
         ResourceEnvRefType<MessageDrivenBeanType<T>>  type = new ResourceEnvRefTypeImpl<MessageDrivenBeanType<T>>(this, "resource-env-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>resource-env-ref</code> elements 
    * @return the current instance of <code>ResourceEnvRefType<MessageDrivenBeanType<T>></code> 
    */
   public MessageDrivenBeanType<T> removeAllResourceEnvRef()
   {
      childNode.removeChildren("resource-env-ref");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: jboss:message-destination-refType ElementType : message-destination-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>message-destination-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>message-destination-ref</code> element will be returned.
    * @return the instance defined for the element <code>message-destination-ref</code> 
    */
   public MessageDestinationRefType<MessageDrivenBeanType<T>> getOrCreateMessageDestinationRef()
   {
      List<Node> nodeList = childNode.get("message-destination-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new MessageDestinationRefTypeImpl<MessageDrivenBeanType<T>>(this, "message-destination-ref", childNode, nodeList.get(0));
      }
      return createMessageDestinationRef();
   }

   /**
    * Creates a new <code>message-destination-ref</code> element 
    * @return the new created instance of <code>MessageDestinationRefType<MessageDrivenBeanType<T>></code> 
    */
   public MessageDestinationRefType<MessageDrivenBeanType<T>> createMessageDestinationRef()
   {
      return new MessageDestinationRefTypeImpl<MessageDrivenBeanType<T>>(this, "message-destination-ref", childNode);
   }

   /**
    * Returns all <code>message-destination-ref</code> elements
    * @return list of <code>message-destination-ref</code> 
    */
   public List<MessageDestinationRefType<MessageDrivenBeanType<T>>> getAllMessageDestinationRef()
   {
      List<MessageDestinationRefType<MessageDrivenBeanType<T>>> list = new ArrayList<MessageDestinationRefType<MessageDrivenBeanType<T>>>();
      List<Node> nodeList = childNode.get("message-destination-ref");
      for(Node node: nodeList)
      {
         MessageDestinationRefType<MessageDrivenBeanType<T>>  type = new MessageDestinationRefTypeImpl<MessageDrivenBeanType<T>>(this, "message-destination-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>message-destination-ref</code> elements 
    * @return the current instance of <code>MessageDestinationRefType<MessageDrivenBeanType<T>></code> 
    */
   public MessageDrivenBeanType<T> removeAllMessageDestinationRef()
   {
      childNode.removeChildren("message-destination-ref");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: jboss:security-identityType ElementType : security-identity
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>security-identity</code> element with the given value will be created.
    * Otherwise, the existing <code>security-identity</code> element will be returned.
    * @return  a new or existing instance of <code>SecurityIdentityType<MessageDrivenBeanType<T>></code> 
    */
   public SecurityIdentityType<MessageDrivenBeanType<T>> getOrCreateSecurityIdentity()
   {
      Node node = childNode.getOrCreate("security-identity");
      SecurityIdentityType<MessageDrivenBeanType<T>> securityIdentity = new SecurityIdentityTypeImpl<MessageDrivenBeanType<T>>(this, "security-identity", childNode, node);
      return securityIdentity;
   }

   /**
    * Removes the <code>security-identity</code> element 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removeSecurityIdentity()
   {
      childNode.removeChildren("security-identity");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: xsd:token ElementType : security-domain
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>security-domain</code> element
    * @param securityDomain the value for the element <code>security-domain</code> 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> securityDomain(String securityDomain)
   {
      childNode.getOrCreate("security-domain").text(securityDomain);
      return this;
   }

   /**
    * Returns the <code>security-domain</code> element
    * @return the node defined for the element <code>security-domain</code> 
    */
   public String getSecurityDomain()
   {
      return childNode.getTextValueForPatternName("security-domain");
   }

   /**
    * Removes the <code>security-domain</code> element 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removeSecurityDomain()
   {
      childNode.removeChildren("security-domain");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: jboss:method-attributesType ElementType : method-attributes
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>method-attributes</code> element with the given value will be created.
    * Otherwise, the existing <code>method-attributes</code> element will be returned.
    * @return  a new or existing instance of <code>MethodAttributesType<MessageDrivenBeanType<T>></code> 
    */
   public MethodAttributesType<MessageDrivenBeanType<T>> getOrCreateMethodAttributes()
   {
      Node node = childNode.getOrCreate("method-attributes");
      MethodAttributesType<MessageDrivenBeanType<T>> methodAttributes = new MethodAttributesTypeImpl<MessageDrivenBeanType<T>>(this, "method-attributes", childNode, node);
      return methodAttributes;
   }

   /**
    * Removes the <code>method-attributes</code> element 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removeMethodAttributes()
   {
      childNode.removeChildren("method-attributes");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: xsd:token ElementType : depends
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>depends</code> elements, 
    * a new <code>depends</code> element 
    * @param values list of <code>depends</code> objects 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> depends(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("depends").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>depends</code> elements
    * @return list of <code>depends</code> 
    */
public List<String> getAllDepends()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("depends");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>depends</code> element 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removeAllDepends()
   {
      childNode.removeChildren("depends");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: jboss:security-identityType ElementType : ejb-timeout-identity
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ejb-timeout-identity</code> element with the given value will be created.
    * Otherwise, the existing <code>ejb-timeout-identity</code> element will be returned.
    * @return  a new or existing instance of <code>SecurityIdentityType<MessageDrivenBeanType<T>></code> 
    */
   public SecurityIdentityType<MessageDrivenBeanType<T>> getOrCreateEjbTimeoutIdentity()
   {
      Node node = childNode.getOrCreate("ejb-timeout-identity");
      SecurityIdentityType<MessageDrivenBeanType<T>> ejbTimeoutIdentity = new SecurityIdentityTypeImpl<MessageDrivenBeanType<T>>(this, "ejb-timeout-identity", childNode, node);
      return ejbTimeoutIdentity;
   }

   /**
    * Removes the <code>ejb-timeout-identity</code> element 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removeEjbTimeoutIdentity()
   {
      childNode.removeChildren("ejb-timeout-identity");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: jboss:annotationType ElementType : annotation
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>annotation</code> element will be created and returned.
    * Otherwise, the first existing <code>annotation</code> element will be returned.
    * @return the instance defined for the element <code>annotation</code> 
    */
   public AnnotationType<MessageDrivenBeanType<T>> getOrCreateAnnotation()
   {
      List<Node> nodeList = childNode.get("annotation");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new AnnotationTypeImpl<MessageDrivenBeanType<T>>(this, "annotation", childNode, nodeList.get(0));
      }
      return createAnnotation();
   }

   /**
    * Creates a new <code>annotation</code> element 
    * @return the new created instance of <code>AnnotationType<MessageDrivenBeanType<T>></code> 
    */
   public AnnotationType<MessageDrivenBeanType<T>> createAnnotation()
   {
      return new AnnotationTypeImpl<MessageDrivenBeanType<T>>(this, "annotation", childNode);
   }

   /**
    * Returns all <code>annotation</code> elements
    * @return list of <code>annotation</code> 
    */
   public List<AnnotationType<MessageDrivenBeanType<T>>> getAllAnnotation()
   {
      List<AnnotationType<MessageDrivenBeanType<T>>> list = new ArrayList<AnnotationType<MessageDrivenBeanType<T>>>();
      List<Node> nodeList = childNode.get("annotation");
      for(Node node: nodeList)
      {
         AnnotationType<MessageDrivenBeanType<T>>  type = new AnnotationTypeImpl<MessageDrivenBeanType<T>>(this, "annotation", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>annotation</code> elements 
    * @return the current instance of <code>AnnotationType<MessageDrivenBeanType<T>></code> 
    */
   public MessageDrivenBeanType<T> removeAllAnnotation()
   {
      childNode.removeChildren("annotation");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: jboss:ignore-dependencyType ElementType : ignore-dependency
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ignore-dependency</code> element with the given value will be created.
    * Otherwise, the existing <code>ignore-dependency</code> element will be returned.
    * @return  a new or existing instance of <code>IgnoreDependencyType<MessageDrivenBeanType<T>></code> 
    */
   public IgnoreDependencyType<MessageDrivenBeanType<T>> getOrCreateIgnoreDependency()
   {
      Node node = childNode.getOrCreate("ignore-dependency");
      IgnoreDependencyType<MessageDrivenBeanType<T>> ignoreDependency = new IgnoreDependencyTypeImpl<MessageDrivenBeanType<T>>(this, "ignore-dependency", childNode, node);
      return ignoreDependency;
   }

   /**
    * Removes the <code>ignore-dependency</code> element 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removeIgnoreDependency()
   {
      childNode.removeChildren("ignore-dependency");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: javaee:string ElementType : aop-domain-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>aop-domain-name</code> element
    * @param aopDomainName the value for the element <code>aop-domain-name</code> 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> aopDomainName(String aopDomainName)
   {
      childNode.getOrCreate("aop-domain-name").text(aopDomainName);
      return this;
   }

   /**
    * Returns the <code>aop-domain-name</code> element
    * @return the node defined for the element <code>aop-domain-name</code> 
    */
   public String getAopDomainName()
   {
      return childNode.getTextValueForPatternName("aop-domain-name");
   }

   /**
    * Removes the <code>aop-domain-name</code> element 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removeAopDomainName()
   {
      childNode.removeChildren("aop-domain-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: jboss:pool-configType ElementType : pool-config
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>pool-config</code> element with the given value will be created.
    * Otherwise, the existing <code>pool-config</code> element will be returned.
    * @return  a new or existing instance of <code>PoolConfigType<MessageDrivenBeanType<T>></code> 
    */
   public PoolConfigType<MessageDrivenBeanType<T>> getOrCreatePoolConfig()
   {
      Node node = childNode.getOrCreate("pool-config");
      PoolConfigType<MessageDrivenBeanType<T>> poolConfig = new PoolConfigTypeImpl<MessageDrivenBeanType<T>>(this, "pool-config", childNode, node);
      return poolConfig;
   }

   /**
    * Removes the <code>pool-config</code> element 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removePoolConfig()
   {
      childNode.removeChildren("pool-config");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: jboss:jndi-refType ElementType : jndi-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>jndi-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>jndi-ref</code> element will be returned.
    * @return the instance defined for the element <code>jndi-ref</code> 
    */
   public JndiRefType<MessageDrivenBeanType<T>> getOrCreateJndiRef()
   {
      List<Node> nodeList = childNode.get("jndi-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new JndiRefTypeImpl<MessageDrivenBeanType<T>>(this, "jndi-ref", childNode, nodeList.get(0));
      }
      return createJndiRef();
   }

   /**
    * Creates a new <code>jndi-ref</code> element 
    * @return the new created instance of <code>JndiRefType<MessageDrivenBeanType<T>></code> 
    */
   public JndiRefType<MessageDrivenBeanType<T>> createJndiRef()
   {
      return new JndiRefTypeImpl<MessageDrivenBeanType<T>>(this, "jndi-ref", childNode);
   }

   /**
    * Returns all <code>jndi-ref</code> elements
    * @return list of <code>jndi-ref</code> 
    */
   public List<JndiRefType<MessageDrivenBeanType<T>>> getAllJndiRef()
   {
      List<JndiRefType<MessageDrivenBeanType<T>>> list = new ArrayList<JndiRefType<MessageDrivenBeanType<T>>>();
      List<Node> nodeList = childNode.get("jndi-ref");
      for(Node node: nodeList)
      {
         JndiRefType<MessageDrivenBeanType<T>>  type = new JndiRefTypeImpl<MessageDrivenBeanType<T>>(this, "jndi-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>jndi-ref</code> elements 
    * @return the current instance of <code>JndiRefType<MessageDrivenBeanType<T>></code> 
    */
   public MessageDrivenBeanType<T> removeAllJndiRef()
   {
      childNode.removeChildren("jndi-ref");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: xsd:boolean ElementType : create-destination
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>create-destination</code> element
    * @param createDestination the value for the element <code>create-destination</code> 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> createDestination(Boolean createDestination)
   {
      childNode.getOrCreate("create-destination").text(createDestination);
      return this;
   }

   /**
    * Returns the <code>create-destination</code> element
    * @return the node defined for the element <code>create-destination</code> 
    */
   public Boolean isCreateDestination()
   {
      return Strings.isTrue(childNode.getTextValueForPatternName("create-destination"));
   }

   /**
    * Removes the <code>create-destination</code> element 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removeCreateDestination()
   {
      childNode.removeChildren("create-destination");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessageDrivenBeanType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> id(String id)
   {
      childNode.attribute("id", id);
      return this;
   }

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
      public String getId()
   {
      return childNode.getAttribute("id");
   }

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>MessageDrivenBeanType<T></code> 
    */
   public MessageDrivenBeanType<T> removeId()
   {
      childNode.removeAttribute("id");
      return this;
   }
}
