package org.jboss.shrinkwrap.descriptor.impl.jboss51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jboss51.WebservicesType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.WebserviceDescriptionType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.WebserviceDescriptionTypeImpl;

/**
 * This class implements the <code> webservicesType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class WebservicesTypeImpl<T> implements Child<T>, WebservicesType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public WebservicesTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public WebservicesTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WebservicesType ElementName: xsd:token ElementType : context-root
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>context-root</code> element
    * @param contextRoot the value for the element <code>context-root</code> 
    * @return the current instance of <code>WebservicesType<T></code> 
    */
   public WebservicesType<T> contextRoot(String contextRoot)
   {
      childNode.getOrCreate("context-root").text(contextRoot);
      return this;
   }

   /**
    * Returns the <code>context-root</code> element
    * @return the node defined for the element <code>context-root</code> 
    */
   public String getContextRoot()
   {
      return childNode.getTextValueForPatternName("context-root");
   }

   /**
    * Removes the <code>context-root</code> element 
    * @return the current instance of <code>WebservicesType<T></code> 
    */
   public WebservicesType<T> removeContextRoot()
   {
      childNode.removeChildren("context-root");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WebservicesType ElementName: jboss:webservice-descriptionType ElementType : webservice-description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>webservice-description</code> element will be created and returned.
    * Otherwise, the first existing <code>webservice-description</code> element will be returned.
    * @return the instance defined for the element <code>webservice-description</code> 
    */
   public WebserviceDescriptionType<WebservicesType<T>> getOrCreateWebserviceDescription()
   {
      List<Node> nodeList = childNode.get("webservice-description");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new WebserviceDescriptionTypeImpl<WebservicesType<T>>(this, "webservice-description", childNode, nodeList.get(0));
      }
      return createWebserviceDescription();
   }

   /**
    * Creates a new <code>webservice-description</code> element 
    * @return the new created instance of <code>WebserviceDescriptionType<WebservicesType<T>></code> 
    */
   public WebserviceDescriptionType<WebservicesType<T>> createWebserviceDescription()
   {
      return new WebserviceDescriptionTypeImpl<WebservicesType<T>>(this, "webservice-description", childNode);
   }

   /**
    * Returns all <code>webservice-description</code> elements
    * @return list of <code>webservice-description</code> 
    */
   public List<WebserviceDescriptionType<WebservicesType<T>>> getAllWebserviceDescription()
   {
      List<WebserviceDescriptionType<WebservicesType<T>>> list = new ArrayList<WebserviceDescriptionType<WebservicesType<T>>>();
      List<Node> nodeList = childNode.get("webservice-description");
      for(Node node: nodeList)
      {
         WebserviceDescriptionType<WebservicesType<T>>  type = new WebserviceDescriptionTypeImpl<WebservicesType<T>>(this, "webservice-description", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>webservice-description</code> elements 
    * @return the current instance of <code>WebserviceDescriptionType<WebservicesType<T>></code> 
    */
   public WebservicesType<T> removeAllWebserviceDescription()
   {
      childNode.removeChildren("webservice-description");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WebservicesType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>WebservicesType<T></code> 
    */
   public WebservicesType<T> id(String id)
   {
      childNode.attribute("id", id);
      return this;
   }

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
      public String getId()
   {
      return childNode.getAttribute("id");
   }

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>WebservicesType<T></code> 
    */
   public WebservicesType<T> removeId()
   {
      childNode.removeAttribute("id");
      return this;
   }
}
