package org.jboss.shrinkwrap.descriptor.impl.jbosscommon51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.StubPropertyType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> stub-propertyType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class StubPropertyTypeImpl<T> implements Child<T>, StubPropertyType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public StubPropertyTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public StubPropertyTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: StubPropertyType ElementName: xsd:string ElementType : prop-name
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>prop-name</code> element
    * @param propName the value for the element <code>prop-name</code> 
    * @return the current instance of <code>StubPropertyType<T></code> 
    */
   public StubPropertyType<T> propName(String propName)
   {
      childNode.getOrCreate("prop-name").text(propName);
      return this;
   }

   /**
    * Returns the <code>prop-name</code> element
    * @return the node defined for the element <code>prop-name</code> 
    */
   public String getPropName()
   {
      return childNode.getTextValueForPatternName("prop-name");
   }

   /**
    * Removes the <code>prop-name</code> element 
    * @return the current instance of <code>StubPropertyType<T></code> 
    */
   public StubPropertyType<T> removePropName()
   {
      childNode.removeChildren("prop-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: StubPropertyType ElementName: xsd:string ElementType : prop-value
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>prop-value</code> element
    * @param propValue the value for the element <code>prop-value</code> 
    * @return the current instance of <code>StubPropertyType<T></code> 
    */
   public StubPropertyType<T> propValue(String propValue)
   {
      childNode.getOrCreate("prop-value").text(propValue);
      return this;
   }

   /**
    * Returns the <code>prop-value</code> element
    * @return the node defined for the element <code>prop-value</code> 
    */
   public String getPropValue()
   {
      return childNode.getTextValueForPatternName("prop-value");
   }

   /**
    * Removes the <code>prop-value</code> element 
    * @return the current instance of <code>StubPropertyType<T></code> 
    */
   public StubPropertyType<T> removePropValue()
   {
      childNode.removeChildren("prop-value");
      return this;
   }
}
