package org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.DeploymentType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.ModuleAliasType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.ModuleAliasTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.FilterType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.FilterTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.DependenciesType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.DependenciesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.ExclusionsType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.ExclusionsTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.ResourcesType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.ResourcesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.TransformerSetType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.TransformerSetTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.LocalLast;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.LocalLastImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.ExcludeSubsystemsType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.ExcludeSubsystemsTypeImpl;

/**
 * This class implements the <code> deploymentType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class DeploymentTypeImpl<T> implements Child<T>, DeploymentType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public DeploymentTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public DeploymentTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:moduleAliasType ElementType : module-alias
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>module-alias</code> element with the given value will be created.
    * Otherwise, the existing <code>module-alias</code> element will be returned.
    * @return  a new or existing instance of <code>ModuleAliasType<DeploymentType<T>></code> 
    */
   public ModuleAliasType<DeploymentType<T>> getOrCreateModuleAlias()
   {
      Node node = childNode.getOrCreate("module-alias");
      ModuleAliasType<DeploymentType<T>> moduleAlias = new ModuleAliasTypeImpl<DeploymentType<T>>(this, "module-alias", childNode, node);
      return moduleAlias;
   }

   /**
    * Removes the <code>module-alias</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeModuleAlias()
   {
      childNode.removeChildren("module-alias");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:filterType ElementType : exports
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exports</code> element with the given value will be created.
    * Otherwise, the existing <code>exports</code> element will be returned.
    * @return  a new or existing instance of <code>FilterType<DeploymentType<T>></code> 
    */
   public FilterType<DeploymentType<T>> getOrCreateExports()
   {
      Node node = childNode.getOrCreate("exports");
      FilterType<DeploymentType<T>> exports = new FilterTypeImpl<DeploymentType<T>>(this, "exports", childNode, node);
      return exports;
   }

   /**
    * Removes the <code>exports</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeExports()
   {
      childNode.removeChildren("exports");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:dependenciesType ElementType : dependencies
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>dependencies</code> element with the given value will be created.
    * Otherwise, the existing <code>dependencies</code> element will be returned.
    * @return  a new or existing instance of <code>DependenciesType<DeploymentType<T>></code> 
    */
   public DependenciesType<DeploymentType<T>> getOrCreateDependencies()
   {
      Node node = childNode.getOrCreate("dependencies");
      DependenciesType<DeploymentType<T>> dependencies = new DependenciesTypeImpl<DeploymentType<T>>(this, "dependencies", childNode, node);
      return dependencies;
   }

   /**
    * Removes the <code>dependencies</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeDependencies()
   {
      childNode.removeChildren("dependencies");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:exclusionsType ElementType : exclusions
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exclusions</code> element with the given value will be created.
    * Otherwise, the existing <code>exclusions</code> element will be returned.
    * @return  a new or existing instance of <code>ExclusionsType<DeploymentType<T>></code> 
    */
   public ExclusionsType<DeploymentType<T>> getOrCreateExclusions()
   {
      Node node = childNode.getOrCreate("exclusions");
      ExclusionsType<DeploymentType<T>> exclusions = new ExclusionsTypeImpl<DeploymentType<T>>(this, "exclusions", childNode, node);
      return exclusions;
   }

   /**
    * Removes the <code>exclusions</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeExclusions()
   {
      childNode.removeChildren("exclusions");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:resourcesType ElementType : resources
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resources</code> element with the given value will be created.
    * Otherwise, the existing <code>resources</code> element will be returned.
    * @return  a new or existing instance of <code>ResourcesType<DeploymentType<T>></code> 
    */
   public ResourcesType<DeploymentType<T>> getOrCreateResources()
   {
      Node node = childNode.getOrCreate("resources");
      ResourcesType<DeploymentType<T>> resources = new ResourcesTypeImpl<DeploymentType<T>>(this, "resources", childNode, node);
      return resources;
   }

   /**
    * Removes the <code>resources</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeResources()
   {
      childNode.removeChildren("resources");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:transformerSetType ElementType : transformers
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>transformers</code> element with the given value will be created.
    * Otherwise, the existing <code>transformers</code> element will be returned.
    * @return  a new or existing instance of <code>TransformerSetType<DeploymentType<T>></code> 
    */
   public TransformerSetType<DeploymentType<T>> getOrCreateTransformers()
   {
      Node node = childNode.getOrCreate("transformers");
      TransformerSetType<DeploymentType<T>> transformers = new TransformerSetTypeImpl<DeploymentType<T>>(this, "transformers", childNode, node);
      return transformers;
   }

   /**
    * Removes the <code>transformers</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeTransformers()
   {
      childNode.removeChildren("transformers");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:localLast ElementType : local-last
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>local-last</code> element with the given value will be created.
    * Otherwise, the existing <code>local-last</code> element will be returned.
    * @return  a new or existing instance of <code>LocalLast<DeploymentType<T>></code> 
    */
   public LocalLast<DeploymentType<T>> getOrCreateLocalLast()
   {
      Node node = childNode.getOrCreate("local-last");
      LocalLast<DeploymentType<T>> localLast = new LocalLastImpl<DeploymentType<T>>(this, "local-last", childNode, node);
      return localLast;
   }

   /**
    * Removes the <code>local-last</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeLocalLast()
   {
      childNode.removeChildren("local-last");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:exclude-subsystemsType ElementType : exclude-subsystems
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exclude-subsystems</code> element with the given value will be created.
    * Otherwise, the existing <code>exclude-subsystems</code> element will be returned.
    * @return  a new or existing instance of <code>ExcludeSubsystemsType<DeploymentType<T>></code> 
    */
   public ExcludeSubsystemsType<DeploymentType<T>> getOrCreateExcludeSubsystems()
   {
      Node node = childNode.getOrCreate("exclude-subsystems");
      ExcludeSubsystemsType<DeploymentType<T>> excludeSubsystems = new ExcludeSubsystemsTypeImpl<DeploymentType<T>>(this, "exclude-subsystems", childNode, node);
      return excludeSubsystems;
   }

   /**
    * Removes the <code>exclude-subsystems</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeExcludeSubsystems()
   {
      childNode.removeChildren("exclude-subsystems");
      return this;
   }
}
