package org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.PathSpecType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> pathSpecType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class PathSpecTypeImpl<T> implements Child<T>, PathSpecType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public PathSpecTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public PathSpecTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PathSpecType ElementName: xsd:string ElementType : path
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>path</code> attribute
    * @param path the value for the attribute <code>path</code> 
    * @return the current instance of <code>PathSpecType<T></code> 
    */
   public PathSpecType<T> path(String path)
   {
      childNode.attribute("path", path);
      return this;
   }

   /**
    * Returns the <code>path</code> attribute
    * @return the value defined for the attribute <code>path</code> 
    */
      public String getPath()
   {
      return childNode.getAttribute("path");
   }

   /**
    * Removes the <code>path</code> attribute 
    * @return the current instance of <code>PathSpecType<T></code> 
    */
   public PathSpecType<T> removePath()
   {
      childNode.removeAttribute("path");
      return this;
   }
}
