package org.jboss.shrinkwrap.descriptor.impl.jbossmodule13; 

import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ModuleAbsentDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import java.util.Map.Entry;

import org.jboss.shrinkwrap.descriptor.api.DescriptorNamespace;

import org.jboss.shrinkwrap.descriptor.spi.node.NodeDescriptorImplBase;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/** 
 * <p> 
 * This deployment descriptor provides the functionalities as described in the  specification
 * <p> 
 * Example:
 * <p> 
 * <code> 
 *     ModuleAbsentDescriptor descriptor = Descriptors.create(ModuleAbsentDescriptor.class);
 * </code> 
 *
 *
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ModuleAbsentDescriptorImpl extends NodeDescriptorImplBase implements DescriptorNamespace<ModuleAbsentDescriptor>, ModuleAbsentDescriptor
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private Node model;

   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ModuleAbsentDescriptorImpl(String descriptorName)
   {
       this(descriptorName, new Node("module-absent"));
   }

   public ModuleAbsentDescriptorImpl(String descriptorName, Node node)
   {
      super(descriptorName);
      this.model = node;
      addDefaultNamespaces();
   }

   // -------------------------------------------------------------------------------------||
   // Methods 
   // -------------------------------------------------------------------------------------||

   public Node getRootNode()
   {
      return model;
   }



   // -------------------------------------------------------------------------------------||
   // Namespace 
   // -------------------------------------------------------------------------------------||


   /**
    * Adds the default namespaces as defined in the specification 
    * @return the current instance of <code>ModuleAbsentDescriptor</code> 
    */
   public ModuleAbsentDescriptor addDefaultNamespaces()
   {
      addNamespace("xmlns", "urn:jboss:module:1.3");
     return this;
   }

   /**
    * Adds a new namespace 
    * @return the current instance of <code>ModuleAbsentDescriptor</code> 
    */
   public ModuleAbsentDescriptor addNamespace(String name, String value)
   {
      model.attribute(name, value);
      return this;
   }

   /**
    * Returns all defined namespaces. 
    * @return all defined namespaces 
    */
   public List<String> getNamespaces()
   {
      List<String> namespaceList = new ArrayList<String>();
      java.util.Map<String, String> attributes = model.getAttributes();
      for (Entry<String, String> e : attributes.entrySet())
      {
         final String name = e.getKey();
         final String value = e.getValue();
         if (value != null && value.startsWith("http://")) 
         {
            namespaceList.add(name + "=" + value);
         }
      }
      return namespaceList;
   }

   /**
    * Removes all existing namespaces. 
    * @return the current instance of <code>ModuleAbsentDescriptor</code> 
    */
   public ModuleAbsentDescriptor removeAllNamespaces()
   {
      List<String> nameSpaceKeys = new ArrayList<String>();
      java.util.Map<String, String> attributes = model.getAttributes();
      for (Entry<String, String> e : attributes.entrySet())
      {
         final String name = e.getKey();
         final String value = e.getValue();
         if (value != null && value.startsWith("http://")) 
         {
            nameSpaceKeys.add(name);
         }
      }
      for (String name: nameSpaceKeys)
      {
         model.removeAttribute(name);
      }
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleAbsentDescriptor ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>ModuleAbsentDescriptor</code> 
    */
   public ModuleAbsentDescriptor name(String name)
   {
      model.attribute("name", name);
      return this;
   }

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
      public String getName()
   {
      return model.getAttribute("name");
   }

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>ModuleAbsentDescriptor</code> 
    */
   public ModuleAbsentDescriptor removeName()
   {
      model.removeAttribute("name");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleAbsentDescriptor ElementName: xsd:string ElementType : slot
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>slot</code> attribute
    * @param slot the value for the attribute <code>slot</code> 
    * @return the current instance of <code>ModuleAbsentDescriptor</code> 
    */
   public ModuleAbsentDescriptor slot(String slot)
   {
      model.attribute("slot", slot);
      return this;
   }

   /**
    * Returns the <code>slot</code> attribute
    * @return the value defined for the attribute <code>slot</code> 
    */
      public String getSlot()
   {
      return model.getAttribute("slot");
   }

   /**
    * Removes the <code>slot</code> attribute 
    * @return the current instance of <code>ModuleAbsentDescriptor</code> 
    */
   public ModuleAbsentDescriptor removeSlot()
   {
      model.removeAttribute("slot");
      return this;
   }

}
