package org.jboss.shrinkwrap.descriptor.impl.jbossmodule15; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.PermissionsType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.PermissionType;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule15.PermissionTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.PermissionType;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule15.PermissionTypeImpl;

/**
 * This class implements the <code> permissionsType </code> xsd type 
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class PermissionsTypeImpl<T> implements Child<T>, PermissionsType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public PermissionsTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public PermissionsTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PermissionsType ElementName: jboss:permissionType ElementType : grant
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>grant</code> element will be created and returned.
    * Otherwise, the first existing <code>grant</code> element will be returned.
    * @return the instance defined for the element <code>grant</code> 
    */
   public PermissionType<PermissionsType<T>> getOrCreateGrant()
   {
      List<Node> nodeList = childNode.get("grant");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new PermissionTypeImpl<PermissionsType<T>>(this, "grant", childNode, nodeList.get(0));
      }
      return createGrant();
   }

   /**
    * Creates a new <code>grant</code> element 
    * @return the new created instance of <code>PermissionType<PermissionsType<T>></code> 
    */
   public PermissionType<PermissionsType<T>> createGrant()
   {
      return new PermissionTypeImpl<PermissionsType<T>>(this, "grant", childNode);
   }

   /**
    * Returns all <code>grant</code> elements
    * @return list of <code>grant</code> 
    */
   public List<PermissionType<PermissionsType<T>>> getAllGrant()
   {
      List<PermissionType<PermissionsType<T>>> list = new ArrayList<PermissionType<PermissionsType<T>>>();
      List<Node> nodeList = childNode.get("grant");
      for(Node node: nodeList)
      {
         PermissionType<PermissionsType<T>>  type = new PermissionTypeImpl<PermissionsType<T>>(this, "grant", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>grant</code> elements 
    * @return the current instance of <code>PermissionType<PermissionsType<T>></code> 
    */
   public PermissionsType<T> removeAllGrant()
   {
      childNode.removeChildren("grant");
      return this;
   }
}
