package org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.ArtifactVersionsType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.ArtifactType;
import org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11.ArtifactTypeImpl;

/**
 * This class implements the <code> artifact-versions-type </code> xsd type 
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ArtifactVersionsTypeImpl<T> implements Child<T>, ArtifactVersionsType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ArtifactVersionsTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ArtifactVersionsTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ArtifactVersionsType ElementName: wildfly:artifact-type ElementType : artifact
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>artifact</code> element will be created and returned.
    * Otherwise, the first existing <code>artifact</code> element will be returned.
    * @return the instance defined for the element <code>artifact</code> 
    */
   public ArtifactType<ArtifactVersionsType<T>> getOrCreateArtifact()
   {
      List<Node> nodeList = childNode.get("artifact");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ArtifactTypeImpl<ArtifactVersionsType<T>>(this, "artifact", childNode, nodeList.get(0));
      }
      return createArtifact();
   }

   /**
    * Creates a new <code>artifact</code> element 
    * @return the new created instance of <code>ArtifactType<ArtifactVersionsType<T>></code> 
    */
   public ArtifactType<ArtifactVersionsType<T>> createArtifact()
   {
      return new ArtifactTypeImpl<ArtifactVersionsType<T>>(this, "artifact", childNode);
   }

   /**
    * Returns all <code>artifact</code> elements
    * @return list of <code>artifact</code> 
    */
   public List<ArtifactType<ArtifactVersionsType<T>>> getAllArtifact()
   {
      List<ArtifactType<ArtifactVersionsType<T>>> list = new ArrayList<ArtifactType<ArtifactVersionsType<T>>>();
      List<Node> nodeList = childNode.get("artifact");
      for(Node node: nodeList)
      {
         ArtifactType<ArtifactVersionsType<T>>  type = new ArtifactTypeImpl<ArtifactVersionsType<T>>(this, "artifact", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>artifact</code> elements 
    * @return the current instance of <code>ArtifactType<ArtifactVersionsType<T>></code> 
    */
   public ArtifactVersionsType<T> removeAllArtifact()
   {
      childNode.removeChildren("artifact");
      return this;
   }
}
