package org.wildfly.swarm.config;

import org.wildfly.swarm.config.JPA;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface JPAConsumer<T extends JPA<T>> {

	/**
	 * Configure a pre-constructed instance of JPA resource
	 * 
	 * @parameter Instance of JPA to configure
	 * @return nothing
	 */
	void accept(T value);

	default JPAConsumer<T> andThen(JPAConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}