package org.wildfly.swarm.config;

import org.wildfly.swarm.config.Jsr77;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface Jsr77Consumer<T extends Jsr77<T>> {

	/**
	 * Configure a pre-constructed instance of Jsr77 resource
	 * 
	 * @parameter Instance of Jsr77 to configure
	 * @return nothing
	 */
	void accept(T value);

	default Jsr77Consumer<T> andThen(Jsr77Consumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}