package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * A SFSB cache
 */
@Address("/subsystem=ejb3/cache=*")
@ResourceType("cache")
public class Cache<T extends Cache<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The aliases by which this cache may also be referenced")
	private List<String> aliases;
	@AttributeDocumentation("The passivation store used by this cache")
	private String passivationStore;

	public Cache(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The aliases by which this cache may also be referenced
	 */
	@ModelNodeBinding(detypedName = "aliases")
	public List<String> aliases() {
		return this.aliases;
	}

	/**
	 * The aliases by which this cache may also be referenced
	 */
	@SuppressWarnings("unchecked")
	public T aliases(java.util.List<String> value) {
		Object oldValue = this.aliases;
		this.aliases = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("aliases", oldValue, value);
		return (T) this;
	}

	/**
	 * The aliases by which this cache may also be referenced
	 */
	@SuppressWarnings("unchecked")
	public T alias(String value) {
		if (this.aliases == null) {
			this.aliases = new java.util.ArrayList<>();
		}
		this.aliases.add(value);
		return (T) this;
	}

	/**
	 * The aliases by which this cache may also be referenced
	 */
	@SuppressWarnings("unchecked")
	public T aliases(String... args) {
		aliases(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The passivation store used by this cache
	 */
	@ModelNodeBinding(detypedName = "passivation-store")
	public String passivationStore() {
		return this.passivationStore;
	}

	/**
	 * The passivation store used by this cache
	 */
	@SuppressWarnings("unchecked")
	public T passivationStore(java.lang.String value) {
		Object oldValue = this.passivationStore;
		this.passivationStore = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("passivationStore", oldValue, value);
		return (T) this;
	}
}