package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.EvictionComponent;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface EvictionComponentConsumer<T extends EvictionComponent<T>> {

	/**
	 * Configure a pre-constructed instance of EvictionComponent resource
	 * 
	 * @parameter Instance of EvictionComponent to configure
	 * @return nothing
	 */
	void accept(T value);

	default EvictionComponentConsumer<T> andThen(
			EvictionComponentConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}