package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.TransactionComponent;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface TransactionComponentConsumer<T extends TransactionComponent<T>> {

	/**
	 * Configure a pre-constructed instance of TransactionComponent resource
	 * 
	 * @parameter Instance of TransactionComponent to configure
	 * @return nothing
	 */
	void accept(T value);

	default TransactionComponentConsumer<T> andThen(
			TransactionComponentConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}