package org.wildfly.swarm.config.jmx;

import org.wildfly.swarm.config.jmx.AuditLogConfiguration;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AuditLogConfigurationConsumer<T extends AuditLogConfiguration<T>> {

	/**
	 * Configure a pre-constructed instance of AuditLogConfiguration resource
	 * 
	 * @parameter Instance of AuditLogConfiguration to configure
	 * @return nothing
	 */
	void accept(T value);

	default AuditLogConfigurationConsumer<T> andThen(
			AuditLogConfigurationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}