package org.wildfly.swarm.config.management.access;

import org.wildfly.swarm.config.management.access.AuditLogLogger;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AuditLogLoggerConsumer<T extends AuditLogLogger<T>> {

	/**
	 * Configure a pre-constructed instance of AuditLogLogger resource
	 * 
	 * @parameter Instance of AuditLogLogger to configure
	 * @return nothing
	 */
	void accept(T value);

	default AuditLogLoggerConsumer<T> andThen(AuditLogLoggerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}