package org.wildfly.swarm.config.management.access;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A json formatter for audit log messages.
 */
@Address("/core-service=management/access=audit/json-formatter=*")
@ResourceType("json-formatter")
public class JsonFormatter<T extends JsonFormatter<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("If true will format the JSON on one line. There may still be values containing new lines, so if having the whole record on one line is important, set escape-new-line or escape-control-characters to true.")
	private Boolean compact;
	@AttributeDocumentation("The date format to use as understood by {@link java.text.SimpleDateFormat}. Will be ignored if include-date=\"false\".")
	private String dateFormat;
	@AttributeDocumentation("The separator between the date and the rest of the formatted log message. Will be ignored if include-date=\"false\".")
	private String dateSeparator;
	@AttributeDocumentation("If true will escape all control characters (ascii entries with a decimal value < 32) with the ascii code in octal, e.g.'\n becomes '#012'. If this is true, it will override escape-new-line=\"false\".")
	private Boolean escapeControlCharacters;
	@AttributeDocumentation("If true will escape all new lines with the ascii code in octal, e.g. \"#012\".")
	private Boolean escapeNewLine;
	@AttributeDocumentation("Whether or not to include the date in the formatted log record.")
	private Boolean includeDate;

	public JsonFormatter(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * If true will format the JSON on one line. There may still be values
	 * containing new lines, so if having the whole record on one line is
	 * important, set escape-new-line or escape-control-characters to true.
	 */
	@ModelNodeBinding(detypedName = "compact")
	public Boolean compact() {
		return this.compact;
	}

	/**
	 * If true will format the JSON on one line. There may still be values
	 * containing new lines, so if having the whole record on one line is
	 * important, set escape-new-line or escape-control-characters to true.
	 */
	@SuppressWarnings("unchecked")
	public T compact(java.lang.Boolean value) {
		Object oldValue = this.compact;
		this.compact = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("compact", oldValue, value);
		return (T) this;
	}

	/**
	 * The date format to use as understood by
	 * {@link java.text.SimpleDateFormat}. Will be ignored if
	 * include-date="false".
	 */
	@ModelNodeBinding(detypedName = "date-format")
	public String dateFormat() {
		return this.dateFormat;
	}

	/**
	 * The date format to use as understood by
	 * {@link java.text.SimpleDateFormat}. Will be ignored if
	 * include-date="false".
	 */
	@SuppressWarnings("unchecked")
	public T dateFormat(java.lang.String value) {
		Object oldValue = this.dateFormat;
		this.dateFormat = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("dateFormat", oldValue, value);
		return (T) this;
	}

	/**
	 * The separator between the date and the rest of the formatted log message.
	 * Will be ignored if include-date="false".
	 */
	@ModelNodeBinding(detypedName = "date-separator")
	public String dateSeparator() {
		return this.dateSeparator;
	}

	/**
	 * The separator between the date and the rest of the formatted log message.
	 * Will be ignored if include-date="false".
	 */
	@SuppressWarnings("unchecked")
	public T dateSeparator(java.lang.String value) {
		Object oldValue = this.dateSeparator;
		this.dateSeparator = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("dateSeparator", oldValue, value);
		return (T) this;
	}

	/**
	 * If true will escape all control characters (ascii entries with a decimal
	 * value < 32) with the ascii code in octal, e.g.' becomes '#012'. If this
	 * is true, it will override escape-new-line="false".
	 */
	@ModelNodeBinding(detypedName = "escape-control-characters")
	public Boolean escapeControlCharacters() {
		return this.escapeControlCharacters;
	}

	/**
	 * If true will escape all control characters (ascii entries with a decimal
	 * value < 32) with the ascii code in octal, e.g.' becomes '#012'. If this
	 * is true, it will override escape-new-line="false".
	 */
	@SuppressWarnings("unchecked")
	public T escapeControlCharacters(java.lang.Boolean value) {
		Object oldValue = this.escapeControlCharacters;
		this.escapeControlCharacters = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("escapeControlCharacters", oldValue,
					value);
		return (T) this;
	}

	/**
	 * If true will escape all new lines with the ascii code in octal, e.g.
	 * "#012".
	 */
	@ModelNodeBinding(detypedName = "escape-new-line")
	public Boolean escapeNewLine() {
		return this.escapeNewLine;
	}

	/**
	 * If true will escape all new lines with the ascii code in octal, e.g.
	 * "#012".
	 */
	@SuppressWarnings("unchecked")
	public T escapeNewLine(java.lang.Boolean value) {
		Object oldValue = this.escapeNewLine;
		this.escapeNewLine = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("escapeNewLine", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether or not to include the date in the formatted log record.
	 */
	@ModelNodeBinding(detypedName = "include-date")
	public Boolean includeDate() {
		return this.includeDate;
	}

	/**
	 * Whether or not to include the date in the formatted log record.
	 */
	@SuppressWarnings("unchecked")
	public T includeDate(java.lang.Boolean value) {
		Object oldValue = this.includeDate;
		this.includeDate = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("includeDate", oldValue, value);
		return (T) this;
	}
}