package org.wildfly.swarm.config.management.access;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.management.access.syslog_handler.TcpProtocol;
import org.wildfly.swarm.config.management.access.syslog_handler.TcpProtocolConsumer;
import org.wildfly.swarm.config.management.access.syslog_handler.TcpProtocolSupplier;
import org.wildfly.swarm.config.management.access.syslog_handler.UdpProtocol;
import org.wildfly.swarm.config.management.access.syslog_handler.UdpProtocolConsumer;
import org.wildfly.swarm.config.management.access.syslog_handler.UdpProtocolSupplier;
import org.wildfly.swarm.config.management.access.syslog_handler.TlsProtocol;
import org.wildfly.swarm.config.management.access.syslog_handler.TlsProtocolConsumer;
import org.wildfly.swarm.config.management.access.syslog_handler.TlsProtocolSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;

/**
 * A syslog handler for use with the management audit logging service.
 */
@Address("/core-service=management/access=audit/syslog-handler=*")
@ResourceType("syslog-handler")
public class SyslogHandler<T extends SyslogHandler<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private SyslogHandlerResources subresources = new SyslogHandlerResources();
	@AttributeDocumentation("The application name to add to the syslog records as defined in section 6.2.5 of RFC-5424. If not specified it will default to the name of the product.")
	private String appName;
	@AttributeDocumentation("Whether this handler has been disabled due to logging failures.")
	private Boolean disabledDueToFailure;
	@AttributeDocumentation("The facility to use for syslog logging as defined in section 6.2.1 of RFC-5424, and section 4.1.1 of RFC-3164.")
	private Facility facility;
	@AttributeDocumentation("The number of logging failures since the handler was initialized.")
	private Integer failureCount;
	@AttributeDocumentation("The formatter used to format the log messages.")
	private String formatter;
	@AttributeDocumentation("The maximum number of logging failures before disabling this handler.")
	private Integer maxFailureCount;
	@AttributeDocumentation("The maximum length in bytes a log message, including the header, is allowed to be. If undefined, it will default to 1024 bytes if the syslog-format is RFC3164, or 2048 bytes if the syslog-format is RFC5424.")
	private Integer maxLength;
	@AttributeDocumentation("Whether to set the syslog format to the one specified in RFC-5424 or RFC-3164.")
	private SyslogFormat syslogFormat;
	@AttributeDocumentation("Whether or not a message, including the header, should truncate the message if the length in bytes is greater than the maximum length. If set to false messages will be split and sent with the same header values.")
	private Boolean truncate;

	public SyslogHandler(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public SyslogHandlerResources subresources() {
		return this.subresources;
	}

	/**
	 * Configuration to append to syslog over tcp/ip.
	 */
	@SuppressWarnings("unchecked")
	public T tcpProtocol(TcpProtocol value) {
		this.subresources.tcpProtocol = value;
		return (T) this;
	}

	/**
	 * Configuration to append to syslog over tcp/ip.
	 */
	@SuppressWarnings("unchecked")
	public T tcpProtocol(TcpProtocolConsumer consumer) {
		TcpProtocol<? extends TcpProtocol> child = new TcpProtocol<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.tcpProtocol = child;
		return (T) this;
	}

	/**
	 * Configuration to append to syslog over tcp/ip.
	 */
	@SuppressWarnings("unchecked")
	public T tcpProtocol() {
		TcpProtocol<? extends TcpProtocol> child = new TcpProtocol<>();
		this.subresources.tcpProtocol = child;
		return (T) this;
	}

	/**
	 * Configuration to append to syslog over tcp/ip.
	 */
	@SuppressWarnings("unchecked")
	public T tcpProtocol(TcpProtocolSupplier supplier) {
		this.subresources.tcpProtocol = supplier.get();
		return (T) this;
	}

	/**
	 * Configuration to append to syslog over udp/ip.
	 */
	@SuppressWarnings("unchecked")
	public T udpProtocol(UdpProtocol value) {
		this.subresources.udpProtocol = value;
		return (T) this;
	}

	/**
	 * Configuration to append to syslog over udp/ip.
	 */
	@SuppressWarnings("unchecked")
	public T udpProtocol(UdpProtocolConsumer consumer) {
		UdpProtocol<? extends UdpProtocol> child = new UdpProtocol<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.udpProtocol = child;
		return (T) this;
	}

	/**
	 * Configuration to append to syslog over udp/ip.
	 */
	@SuppressWarnings("unchecked")
	public T udpProtocol() {
		UdpProtocol<? extends UdpProtocol> child = new UdpProtocol<>();
		this.subresources.udpProtocol = child;
		return (T) this;
	}

	/**
	 * Configuration to append to syslog over udp/ip.
	 */
	@SuppressWarnings("unchecked")
	public T udpProtocol(UdpProtocolSupplier supplier) {
		this.subresources.udpProtocol = supplier.get();
		return (T) this;
	}

	/**
	 * Configuration to append to syslog over tls over tcp/ip.
	 */
	@SuppressWarnings("unchecked")
	public T tlsProtocol(TlsProtocol value) {
		this.subresources.tlsProtocol = value;
		return (T) this;
	}

	/**
	 * Configuration to append to syslog over tls over tcp/ip.
	 */
	@SuppressWarnings("unchecked")
	public T tlsProtocol(TlsProtocolConsumer consumer) {
		TlsProtocol<? extends TlsProtocol> child = new TlsProtocol<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.tlsProtocol = child;
		return (T) this;
	}

	/**
	 * Configuration to append to syslog over tls over tcp/ip.
	 */
	@SuppressWarnings("unchecked")
	public T tlsProtocol() {
		TlsProtocol<? extends TlsProtocol> child = new TlsProtocol<>();
		this.subresources.tlsProtocol = child;
		return (T) this;
	}

	/**
	 * Configuration to append to syslog over tls over tcp/ip.
	 */
	@SuppressWarnings("unchecked")
	public T tlsProtocol(TlsProtocolSupplier supplier) {
		this.subresources.tlsProtocol = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for SyslogHandler
	 */
	public static class SyslogHandlerResources {
		@SingletonResource
		@ResourceDocumentation("Configuration to append to syslog over tcp/ip.")
		private TcpProtocol tcpProtocol;
		@SingletonResource
		@ResourceDocumentation("Configuration to append to syslog over udp/ip.")
		private UdpProtocol udpProtocol;
		@SingletonResource
		@ResourceDocumentation("Configuration to append to syslog over tls over tcp/ip.")
		private TlsProtocol tlsProtocol;

		/**
		 * Configuration to append to syslog over tcp/ip.
		 */
		@Subresource
		public TcpProtocol tcpProtocol() {
			return this.tcpProtocol;
		}

		/**
		 * Configuration to append to syslog over udp/ip.
		 */
		@Subresource
		public UdpProtocol udpProtocol() {
			return this.udpProtocol;
		}

		/**
		 * Configuration to append to syslog over tls over tcp/ip.
		 */
		@Subresource
		public TlsProtocol tlsProtocol() {
			return this.tlsProtocol;
		}
	}

	public static enum Facility {
		KERNEL("KERNEL"), USER_LEVEL("USER_LEVEL"), MAIL_SYSTEM("MAIL_SYSTEM"), SYSTEM_DAEMONS(
				"SYSTEM_DAEMONS"), SECURITY("SECURITY"), SYSLOGD("SYSLOGD"), LINE_PRINTER(
				"LINE_PRINTER"), NETWORK_NEWS("NETWORK_NEWS"), UUCP("UUCP"), CLOCK_DAEMON(
				"CLOCK_DAEMON"), SECURITY2("SECURITY2"), FTP_DAEMON(
				"FTP_DAEMON"), NTP("NTP"), LOG_AUDIT("LOG_AUDIT"), LOG_ALERT(
				"LOG_ALERT"), CLOCK_DAEMON2("CLOCK_DAEMON2"), LOCAL_USE_0(
				"LOCAL_USE_0"), LOCAL_USE_1("LOCAL_USE_1"), LOCAL_USE_2(
				"LOCAL_USE_2"), LOCAL_USE_3("LOCAL_USE_3"), LOCAL_USE_4(
				"LOCAL_USE_4"), LOCAL_USE_5("LOCAL_USE_5"), LOCAL_USE_6(
				"LOCAL_USE_6"), LOCAL_USE_7("LOCAL_USE_7");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		Facility(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	public static enum SyslogFormat {
		RFC5424("RFC5424"), RFC3164("RFC3164");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		SyslogFormat(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * The application name to add to the syslog records as defined in section
	 * 6.2.5 of RFC-5424. If not specified it will default to the name of the
	 * product.
	 */
	@ModelNodeBinding(detypedName = "app-name")
	public String appName() {
		return this.appName;
	}

	/**
	 * The application name to add to the syslog records as defined in section
	 * 6.2.5 of RFC-5424. If not specified it will default to the name of the
	 * product.
	 */
	@SuppressWarnings("unchecked")
	public T appName(java.lang.String value) {
		Object oldValue = this.appName;
		this.appName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("appName", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether this handler has been disabled due to logging failures.
	 */
	@ModelNodeBinding(detypedName = "disabled-due-to-failure")
	public Boolean disabledDueToFailure() {
		return this.disabledDueToFailure;
	}

	/**
	 * Whether this handler has been disabled due to logging failures.
	 */
	@SuppressWarnings("unchecked")
	public T disabledDueToFailure(java.lang.Boolean value) {
		Object oldValue = this.disabledDueToFailure;
		this.disabledDueToFailure = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("disabledDueToFailure", oldValue, value);
		return (T) this;
	}

	/**
	 * The facility to use for syslog logging as defined in section 6.2.1 of
	 * RFC-5424, and section 4.1.1 of RFC-3164.
	 */
	@ModelNodeBinding(detypedName = "facility")
	public Facility facility() {
		return this.facility;
	}

	/**
	 * The facility to use for syslog logging as defined in section 6.2.1 of
	 * RFC-5424, and section 4.1.1 of RFC-3164.
	 */
	@SuppressWarnings("unchecked")
	public T facility(Facility value) {
		Object oldValue = this.facility;
		this.facility = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("facility", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of logging failures since the handler was initialized.
	 */
	@ModelNodeBinding(detypedName = "failure-count")
	public Integer failureCount() {
		return this.failureCount;
	}

	/**
	 * The number of logging failures since the handler was initialized.
	 */
	@SuppressWarnings("unchecked")
	public T failureCount(java.lang.Integer value) {
		Object oldValue = this.failureCount;
		this.failureCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("failureCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The formatter used to format the log messages.
	 */
	@ModelNodeBinding(detypedName = "formatter")
	public String formatter() {
		return this.formatter;
	}

	/**
	 * The formatter used to format the log messages.
	 */
	@SuppressWarnings("unchecked")
	public T formatter(java.lang.String value) {
		Object oldValue = this.formatter;
		this.formatter = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("formatter", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of logging failures before disabling this handler.
	 */
	@ModelNodeBinding(detypedName = "max-failure-count")
	public Integer maxFailureCount() {
		return this.maxFailureCount;
	}

	/**
	 * The maximum number of logging failures before disabling this handler.
	 */
	@SuppressWarnings("unchecked")
	public T maxFailureCount(java.lang.Integer value) {
		Object oldValue = this.maxFailureCount;
		this.maxFailureCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxFailureCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum length in bytes a log message, including the header, is
	 * allowed to be. If undefined, it will default to 1024 bytes if the
	 * syslog-format is RFC3164, or 2048 bytes if the syslog-format is RFC5424.
	 */
	@ModelNodeBinding(detypedName = "max-length")
	public Integer maxLength() {
		return this.maxLength;
	}

	/**
	 * The maximum length in bytes a log message, including the header, is
	 * allowed to be. If undefined, it will default to 1024 bytes if the
	 * syslog-format is RFC3164, or 2048 bytes if the syslog-format is RFC5424.
	 */
	@SuppressWarnings("unchecked")
	public T maxLength(java.lang.Integer value) {
		Object oldValue = this.maxLength;
		this.maxLength = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxLength", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether to set the syslog format to the one specified in RFC-5424 or
	 * RFC-3164.
	 */
	@ModelNodeBinding(detypedName = "syslog-format")
	public SyslogFormat syslogFormat() {
		return this.syslogFormat;
	}

	/**
	 * Whether to set the syslog format to the one specified in RFC-5424 or
	 * RFC-3164.
	 */
	@SuppressWarnings("unchecked")
	public T syslogFormat(SyslogFormat value) {
		Object oldValue = this.syslogFormat;
		this.syslogFormat = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("syslogFormat", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether or not a message, including the header, should truncate the
	 * message if the length in bytes is greater than the maximum length. If set
	 * to false messages will be split and sent with the same header values.
	 */
	@ModelNodeBinding(detypedName = "truncate")
	public Boolean truncate() {
		return this.truncate;
	}

	/**
	 * Whether or not a message, including the header, should truncate the
	 * message if the length in bytes is greater than the maximum length. If set
	 * to false messages will be split and sent with the same header values.
	 */
	@SuppressWarnings("unchecked")
	public T truncate(java.lang.Boolean value) {
		Object oldValue = this.truncate;
		this.truncate = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("truncate", oldValue, value);
		return (T) this;
	}
}