package org.wildfly.swarm.config.management.security_realm.authorization;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCache;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCacheConsumer;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCacheSupplier;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCache;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCacheConsumer;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCacheSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import org.wildfly.swarm.config.management.core.service.GroupName;

/**
 * A group search where the principal entries contain an attribute referencing
 * the groups that they are a member of.
 */
@Address("/core-service=management/security-realm=*/authorization=ldap/group-search=principal-to-group")
@ResourceType("group-search")
@Implicit
public class PrincipalToGroupGroupSearch<T extends PrincipalToGroupGroupSearch<T>>
		extends
			HashMap implements org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private PrincipalToGroupGroupSearchResources subresources = new PrincipalToGroupGroupSearchResources();
	@AttributeDocumentation("The attribute on the principal which references the group the principal is a member of.")
	private String groupAttribute;
	@AttributeDocumentation("Which attribute on a group entry is it's distinguished name.")
	private String groupDnAttribute;
	@AttributeDocumentation("An enumeration to identify if groups should be referenced using a simple name or their distinguished name.")
	private GroupName groupName;
	@AttributeDocumentation("Which attribute on a group entry is it's simple name.")
	private String groupNameAttribute;
	@AttributeDocumentation("Should further searches be performed to identify groups that the groups identified are a member of?")
	private Boolean iterative;
	@AttributeDocumentation("After following a referral should subsequent searches prefer the original connection or use the connection of the last referral.")
	private Boolean preferOriginalConnection;
	@AttributeDocumentation("If a non-existent group is referenced should it be quietly ignored.")
	private Boolean skipMissingGroups;

	public PrincipalToGroupGroupSearch() {
		super();
		this.key = "principal-to-group";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public PrincipalToGroupGroupSearchResources subresources() {
		return this.subresources;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache(BySearchTimeCache value) {
		this.subresources.bySearchTimeCache = value;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache(BySearchTimeCacheConsumer consumer) {
		BySearchTimeCache<? extends BySearchTimeCache> child = new BySearchTimeCache<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.bySearchTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache() {
		BySearchTimeCache<? extends BySearchTimeCache> child = new BySearchTimeCache<>();
		this.subresources.bySearchTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache(BySearchTimeCacheSupplier supplier) {
		this.subresources.bySearchTimeCache = supplier.get();
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache(ByAccessTimeCache value) {
		this.subresources.byAccessTimeCache = value;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache(ByAccessTimeCacheConsumer consumer) {
		ByAccessTimeCache<? extends ByAccessTimeCache> child = new ByAccessTimeCache<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.byAccessTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache() {
		ByAccessTimeCache<? extends ByAccessTimeCache> child = new ByAccessTimeCache<>();
		this.subresources.byAccessTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache(ByAccessTimeCacheSupplier supplier) {
		this.subresources.byAccessTimeCache = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for PrincipalToGroupGroupSearch
	 */
	public static class PrincipalToGroupGroupSearchResources {
		@SingletonResource
		@ResourceDocumentation("A cache to hold the results of previous LDAP interactions.")
		private BySearchTimeCache bySearchTimeCache;
		@SingletonResource
		@ResourceDocumentation("A cache to hold the results of previous LDAP interactions.")
		private ByAccessTimeCache byAccessTimeCache;

		/**
		 * A cache to hold the results of previous LDAP interactions.
		 */
		@Subresource
		public BySearchTimeCache bySearchTimeCache() {
			return this.bySearchTimeCache;
		}

		/**
		 * A cache to hold the results of previous LDAP interactions.
		 */
		@Subresource
		public ByAccessTimeCache byAccessTimeCache() {
			return this.byAccessTimeCache;
		}
	}

	/**
	 * The attribute on the principal which references the group the principal
	 * is a member of.
	 */
	@ModelNodeBinding(detypedName = "group-attribute")
	public String groupAttribute() {
		return this.groupAttribute;
	}

	/**
	 * The attribute on the principal which references the group the principal
	 * is a member of.
	 */
	@SuppressWarnings("unchecked")
	public T groupAttribute(java.lang.String value) {
		Object oldValue = this.groupAttribute;
		this.groupAttribute = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("groupAttribute", oldValue, value);
		return (T) this;
	}

	/**
	 * Which attribute on a group entry is it's distinguished name.
	 */
	@ModelNodeBinding(detypedName = "group-dn-attribute")
	public String groupDnAttribute() {
		return this.groupDnAttribute;
	}

	/**
	 * Which attribute on a group entry is it's distinguished name.
	 */
	@SuppressWarnings("unchecked")
	public T groupDnAttribute(java.lang.String value) {
		Object oldValue = this.groupDnAttribute;
		this.groupDnAttribute = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("groupDnAttribute", oldValue, value);
		return (T) this;
	}

	/**
	 * An enumeration to identify if groups should be referenced using a simple
	 * name or their distinguished name.
	 */
	@ModelNodeBinding(detypedName = "group-name")
	public GroupName groupName() {
		return this.groupName;
	}

	/**
	 * An enumeration to identify if groups should be referenced using a simple
	 * name or their distinguished name.
	 */
	@SuppressWarnings("unchecked")
	public T groupName(GroupName value) {
		Object oldValue = this.groupName;
		this.groupName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("groupName", oldValue, value);
		return (T) this;
	}

	/**
	 * Which attribute on a group entry is it's simple name.
	 */
	@ModelNodeBinding(detypedName = "group-name-attribute")
	public String groupNameAttribute() {
		return this.groupNameAttribute;
	}

	/**
	 * Which attribute on a group entry is it's simple name.
	 */
	@SuppressWarnings("unchecked")
	public T groupNameAttribute(java.lang.String value) {
		Object oldValue = this.groupNameAttribute;
		this.groupNameAttribute = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("groupNameAttribute", oldValue, value);
		return (T) this;
	}

	/**
	 * Should further searches be performed to identify groups that the groups
	 * identified are a member of?
	 */
	@ModelNodeBinding(detypedName = "iterative")
	public Boolean iterative() {
		return this.iterative;
	}

	/**
	 * Should further searches be performed to identify groups that the groups
	 * identified are a member of?
	 */
	@SuppressWarnings("unchecked")
	public T iterative(java.lang.Boolean value) {
		Object oldValue = this.iterative;
		this.iterative = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("iterative", oldValue, value);
		return (T) this;
	}

	/**
	 * After following a referral should subsequent searches prefer the original
	 * connection or use the connection of the last referral.
	 */
	@ModelNodeBinding(detypedName = "prefer-original-connection")
	public Boolean preferOriginalConnection() {
		return this.preferOriginalConnection;
	}

	/**
	 * After following a referral should subsequent searches prefer the original
	 * connection or use the connection of the last referral.
	 */
	@SuppressWarnings("unchecked")
	public T preferOriginalConnection(java.lang.Boolean value) {
		Object oldValue = this.preferOriginalConnection;
		this.preferOriginalConnection = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("preferOriginalConnection", oldValue,
					value);
		return (T) this;
	}

	/**
	 * If a non-existent group is referenced should it be quietly ignored.
	 */
	@ModelNodeBinding(detypedName = "skip-missing-groups")
	public Boolean skipMissingGroups() {
		return this.skipMissingGroups;
	}

	/**
	 * If a non-existent group is referenced should it be quietly ignored.
	 */
	@SuppressWarnings("unchecked")
	public T skipMissingGroups(java.lang.Boolean value) {
		Object oldValue = this.skipMissingGroups;
		this.skipMissingGroups = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("skipMissingGroups", oldValue, value);
		return (T) this;
	}
}