package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreColocatedHAPolicy;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SharedStoreColocatedHAPolicyConsumer<T extends SharedStoreColocatedHAPolicy<T>> {

	/**
	 * Configure a pre-constructed instance of SharedStoreColocatedHAPolicy
	 * resource
	 * 
	 * @parameter Instance of SharedStoreColocatedHAPolicy to configure
	 * @return nothing
	 */
	void accept(T value);

	default SharedStoreColocatedHAPolicyConsumer<T> andThen(
			SharedStoreColocatedHAPolicyConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}