package org.wildfly.swarm.config.modcluster.mod_cluster_config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider.LoadMetricConsumer;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider.LoadMetricSupplier;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider.LoadMetric;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider.CustomLoadMetricConsumer;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider.CustomLoadMetricSupplier;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider.CustomLoadMetric;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Dynamic load provider
 */
@Address("/subsystem=modcluster/mod-cluster-config=configuration/dynamic-load-provider=configuration")
@ResourceType("dynamic-load-provider")
@Implicit
public class ConfigurationDynamicLoadProvider<T extends ConfigurationDynamicLoadProvider<T>>
		extends
			HashMap implements org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private ConfigurationDynamicLoadProviderResources subresources = new ConfigurationDynamicLoadProviderResources();
	@AttributeDocumentation("Decay")
	private Integer decay;
	@AttributeDocumentation("History")
	private Integer history;

	public ConfigurationDynamicLoadProvider() {
		super();
		this.key = "configuration";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ConfigurationDynamicLoadProviderResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all LoadMetric objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of LoadMetric objects.
	 */
	@SuppressWarnings("unchecked")
	public T loadMetrics(java.util.List<LoadMetric> value) {
		this.subresources.loadMetrics = value;
		return (T) this;
	}

	/**
	 * Add the LoadMetric object to the list of subresources
	 * 
	 * @param value
	 *            The LoadMetric to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T loadMetric(LoadMetric value) {
		this.subresources.loadMetrics.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a LoadMetric object to the list of subresources
	 * 
	 * @param key
	 *            The key for the LoadMetric resource
	 * @param config
	 *            The LoadMetricConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T loadMetric(java.lang.String childKey, LoadMetricConsumer consumer) {
		LoadMetric<? extends LoadMetric> child = new LoadMetric<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		loadMetric(child);
		return (T) this;
	}

	/**
	 * Create and configure a LoadMetric object to the list of subresources
	 * 
	 * @param key
	 *            The key for the LoadMetric resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T loadMetric(java.lang.String childKey) {
		loadMetric(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied LoadMetric object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T loadMetric(LoadMetricSupplier supplier) {
		loadMetric(supplier.get());
		return (T) this;
	}

	/**
	 * Add all CustomLoadMetric objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CustomLoadMetric objects.
	 */
	@SuppressWarnings("unchecked")
	public T customLoadMetrics(java.util.List<CustomLoadMetric> value) {
		this.subresources.customLoadMetrics = value;
		return (T) this;
	}

	/**
	 * Add the CustomLoadMetric object to the list of subresources
	 * 
	 * @param value
	 *            The CustomLoadMetric to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customLoadMetric(CustomLoadMetric value) {
		this.subresources.customLoadMetrics.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CustomLoadMetric object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CustomLoadMetric resource
	 * @param config
	 *            The CustomLoadMetricConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customLoadMetric(java.lang.String childKey,
			CustomLoadMetricConsumer consumer) {
		CustomLoadMetric<? extends CustomLoadMetric> child = new CustomLoadMetric<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		customLoadMetric(child);
		return (T) this;
	}

	/**
	 * Create and configure a CustomLoadMetric object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CustomLoadMetric resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customLoadMetric(java.lang.String childKey) {
		customLoadMetric(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CustomLoadMetric object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T customLoadMetric(CustomLoadMetricSupplier supplier) {
		customLoadMetric(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for ConfigurationDynamicLoadProvider
	 */
	public static class ConfigurationDynamicLoadProviderResources {
		/**
		 * Load metric definition
		 */
		@ResourceDocumentation("Load metric definition")
		@SubresourceInfo("loadMetric")
		private List<LoadMetric> loadMetrics = new java.util.ArrayList<>();
		/**
		 * Load metric definition
		 */
		@ResourceDocumentation("Load metric definition")
		@SubresourceInfo("customLoadMetric")
		private List<CustomLoadMetric> customLoadMetrics = new java.util.ArrayList<>();

		/**
		 * Get the list of LoadMetric resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<LoadMetric> loadMetrics() {
			return this.loadMetrics;
		}

		public LoadMetric loadMetric(java.lang.String key) {
			return this.loadMetrics.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of CustomLoadMetric resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CustomLoadMetric> customLoadMetrics() {
			return this.customLoadMetrics;
		}

		public CustomLoadMetric customLoadMetric(java.lang.String key) {
			return this.customLoadMetrics.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}

	/**
	 * Decay
	 */
	@ModelNodeBinding(detypedName = "decay")
	public Integer decay() {
		return this.decay;
	}

	/**
	 * Decay
	 */
	@SuppressWarnings("unchecked")
	public T decay(java.lang.Integer value) {
		Object oldValue = this.decay;
		this.decay = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("decay", oldValue, value);
		return (T) this;
	}

	/**
	 * History
	 */
	@ModelNodeBinding(detypedName = "history")
	public Integer history() {
		return this.history;
	}

	/**
	 * History
	 */
	@SuppressWarnings("unchecked")
	public T history(java.lang.Integer value) {
		Object oldValue = this.history;
		this.history = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("history", oldValue, value);
		return (T) this;
	}
}