package org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * Load metric definition
 */
@Address("/subsystem=modcluster/mod-cluster-config=configuration/dynamic-load-provider=configuration/custom-load-metric=*")
@ResourceType("custom-load-metric")
public class CustomLoadMetric<T extends CustomLoadMetric<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Capacity of the metric.")
	private Double capacity;
	@AttributeDocumentation("Class name of the custom metric.")
	private String attributeClass;
	@AttributeDocumentation("Properties for the metric.")
	private Map property;
	@AttributeDocumentation("Weight of the metric.")
	private Integer weight;

	public CustomLoadMetric(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Capacity of the metric.
	 */
	@ModelNodeBinding(detypedName = "capacity")
	public Double capacity() {
		return this.capacity;
	}

	/**
	 * Capacity of the metric.
	 */
	@SuppressWarnings("unchecked")
	public T capacity(java.lang.Double value) {
		Object oldValue = this.capacity;
		this.capacity = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("capacity", oldValue, value);
		return (T) this;
	}

	/**
	 * Class name of the custom metric.
	 */
	@ModelNodeBinding(detypedName = "class")
	public String attributeClass() {
		return this.attributeClass;
	}

	/**
	 * Class name of the custom metric.
	 */
	@SuppressWarnings("unchecked")
	public T attributeClass(java.lang.String value) {
		Object oldValue = this.attributeClass;
		this.attributeClass = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attributeClass", oldValue, value);
		return (T) this;
	}

	/**
	 * Properties for the metric.
	 */
	@ModelNodeBinding(detypedName = "property")
	public Map property() {
		return this.property;
	}

	/**
	 * Properties for the metric.
	 */
	@SuppressWarnings("unchecked")
	public T property(java.util.Map value) {
		Object oldValue = this.property;
		this.property = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("property", oldValue, value);
		return (T) this;
	}

	/**
	 * Properties for the metric.
	 */
	@SuppressWarnings("unchecked")
	public T property(java.lang.String key, java.lang.Object value) {
		if (this.property == null) {
			this.property = new java.util.HashMap<>();
		}
		this.property.put(key, value);
		return (T) this;
	}

	/**
	 * Weight of the metric.
	 */
	@ModelNodeBinding(detypedName = "weight")
	public Integer weight() {
		return this.weight;
	}

	/**
	 * Weight of the metric.
	 */
	@SuppressWarnings("unchecked")
	public T weight(java.lang.Integer value) {
		Object oldValue = this.weight;
		this.weight = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("weight", oldValue, value);
		return (T) this;
	}
}