package org.wildfly.swarm.config.transactions.log_store.transactions;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;

/**
 * The resources that did work in a transaction.
 */
@Address("/subsystem=transactions/log-store=log-store/transactions=*/participants=*")
@ResourceType("participants")
public class Participants<T extends Participants<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The JCA enterprise information system's product name.")
	private String eisProductName;
	@AttributeDocumentation("The JCA enterprise information system's product version")
	private String eisProductVersion;
	@AttributeDocumentation("The JMX name of this participant.")
	private String jmxName;
	@AttributeDocumentation("JNDI name of this participant.")
	private String jndiName;
	@AttributeDocumentation("Reports the commitment status of this participant (can be one of Pending, Prepared, Failed, Heuristic or Readonly).")
	private Status status;
	@AttributeDocumentation("The type name under which this record is stored.")
	private String type;

	public Participants(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public static enum Status {
		PENDING("PENDING"), PREPARED("PREPARED"), FAILED("FAILED"), HEURISTIC(
				"HEURISTIC"), READONLY("READONLY");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		Status(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * The JCA enterprise information system's product name.
	 */
	@ModelNodeBinding(detypedName = "eis-product-name")
	public String eisProductName() {
		return this.eisProductName;
	}

	/**
	 * The JCA enterprise information system's product name.
	 */
	@SuppressWarnings("unchecked")
	public T eisProductName(java.lang.String value) {
		Object oldValue = this.eisProductName;
		this.eisProductName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("eisProductName", oldValue, value);
		return (T) this;
	}

	/**
	 * The JCA enterprise information system's product version
	 */
	@ModelNodeBinding(detypedName = "eis-product-version")
	public String eisProductVersion() {
		return this.eisProductVersion;
	}

	/**
	 * The JCA enterprise information system's product version
	 */
	@SuppressWarnings("unchecked")
	public T eisProductVersion(java.lang.String value) {
		Object oldValue = this.eisProductVersion;
		this.eisProductVersion = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("eisProductVersion", oldValue, value);
		return (T) this;
	}

	/**
	 * The JMX name of this participant.
	 */
	@ModelNodeBinding(detypedName = "jmx-name")
	public String jmxName() {
		return this.jmxName;
	}

	/**
	 * The JMX name of this participant.
	 */
	@SuppressWarnings("unchecked")
	public T jmxName(java.lang.String value) {
		Object oldValue = this.jmxName;
		this.jmxName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jmxName", oldValue, value);
		return (T) this;
	}

	/**
	 * JNDI name of this participant.
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * JNDI name of this participant.
	 */
	@SuppressWarnings("unchecked")
	public T jndiName(java.lang.String value) {
		Object oldValue = this.jndiName;
		this.jndiName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jndiName", oldValue, value);
		return (T) this;
	}

	/**
	 * Reports the commitment status of this participant (can be one of Pending,
	 * Prepared, Failed, Heuristic or Readonly).
	 */
	@ModelNodeBinding(detypedName = "status")
	public Status status() {
		return this.status;
	}

	/**
	 * Reports the commitment status of this participant (can be one of Pending,
	 * Prepared, Failed, Heuristic or Readonly).
	 */
	@SuppressWarnings("unchecked")
	public T status(Status value) {
		Object oldValue = this.status;
		this.status = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("status", oldValue, value);
		return (T) this;
	}

	/**
	 * The type name under which this record is stored.
	 */
	@ModelNodeBinding(detypedName = "type")
	public String type() {
		return this.type;
	}

	/**
	 * The type name under which this record is stored.
	 */
	@SuppressWarnings("unchecked")
	public T type(java.lang.String value) {
		Object oldValue = this.type;
		this.type = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("type", oldValue, value);
		return (T) this;
	}
}