package org.wildfly.swarm.config.undertow.servlet_container;

import org.wildfly.swarm.config.undertow.servlet_container.SessionCookieSetting;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SessionCookieSettingConsumer<T extends SessionCookieSetting<T>> {

	/**
	 * Configure a pre-constructed instance of SessionCookieSetting resource
	 * 
	 * @parameter Instance of SessionCookieSetting to configure
	 * @return nothing
	 */
	void accept(T value);

	default SessionCookieSettingConsumer<T> andThen(
			SessionCookieSettingConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}