package org.jboss.shrinkwrap.descriptor.api.jboss51; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.InjectionTargetType;
import org.jboss.shrinkwrap.descriptor.api.jboss51.AnnotationPropertyType;
/**
 * This interface defines the contract for the <code> annotationType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface AnnotationType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> description(String ... values);

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
   public List<String> getAllDescription();

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> removeAllDescription();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: javaee:fully-qualified-classType ElementType : annotation-class
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>annotation-class</code> element
    * @param annotationClass the value for the element <code>annotation-class</code> 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> annotationClass(String annotationClass);

   /**
    * Returns the <code>annotation-class</code> element
    * @return the node defined for the element <code>annotation-class</code> 
    */
   public String getAnnotationClass();

   /**
    * Removes the <code>annotation-class</code> element 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> removeAnnotationClass();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: javaee:fully-qualified-classType ElementType : annotation-implementation-class
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>annotation-implementation-class</code> element
    * @param annotationImplementationClass the value for the element <code>annotation-implementation-class</code> 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> annotationImplementationClass(String annotationImplementationClass);

   /**
    * Returns the <code>annotation-implementation-class</code> element
    * @return the node defined for the element <code>annotation-implementation-class</code> 
    */
   public String getAnnotationImplementationClass();

   /**
    * Removes the <code>annotation-implementation-class</code> element 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> removeAnnotationImplementationClass();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: jboss:injection-targetType ElementType : injection-target
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>injection-target</code> element with the given value will be created.
    * Otherwise, the existing <code>injection-target</code> element will be returned.
    * @return  a new or existing instance of <code>InjectionTargetType<AnnotationType<T>></code> 
    */
   public InjectionTargetType<AnnotationType<T>> getOrCreateInjectionTarget();

   /**
    * Removes the <code>injection-target</code> element 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> removeInjectionTarget();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: jboss:annotation-propertyType ElementType : property
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>property</code> element will be created and returned.
    * Otherwise, the first existing <code>property</code> element will be returned.
    * @return the instance defined for the element <code>property</code> 
    */
   public AnnotationPropertyType<AnnotationType<T>> getOrCreateProperty();

   /**
    * Creates a new <code>property</code> element 
    * @return the new created instance of <code>AnnotationPropertyType<AnnotationType<T>></code> 
    */
   public AnnotationPropertyType<AnnotationType<T>> createProperty();

   /**
    * Returns all <code>property</code> elements
    * @return list of <code>property</code> 
    */
   public List<AnnotationPropertyType<AnnotationType<T>>> getAllProperty();

   /**
    * Removes all <code>property</code> elements 
    * @return the current instance of <code>AnnotationPropertyType<AnnotationType<T>></code> 
    */
   public AnnotationType<T> removeAllProperty();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> id(String id);

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
   public String getId();

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> removeId();
}
