package org.jboss.shrinkwrap.descriptor.api.jboss51; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ProducerType;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ProducerType;
import org.jboss.shrinkwrap.descriptor.api.jboss51.MethodAttributesType;
import org.jboss.shrinkwrap.descriptor.api.jboss51.MessagePropertiesType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.EjbRefType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.EjbLocalRefType;
import org.jboss.shrinkwrap.descriptor.api.jboss51.SecurityIdentityType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.ResourceRefType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.ResourceEnvRefType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.MessageDestinationRefType;
import org.jboss.shrinkwrap.descriptor.api.jboss51.MethodAttributesType;
import org.jboss.shrinkwrap.descriptor.api.jboss51.AnnotationType;
import org.jboss.shrinkwrap.descriptor.api.jboss51.IgnoreDependencyType;
import org.jboss.shrinkwrap.descriptor.api.jboss51.PoolConfigType;
import org.jboss.shrinkwrap.descriptor.api.jboss51.JndiRefType;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ActivationConfigType;
import org.jboss.shrinkwrap.descriptor.api.javaee5.IconType;
/**
 * This interface defines the contract for the <code> consumer-beanType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ConsumerBeanType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> description(String ... values);

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
   public List<String> getAllDescription();

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeAllDescription();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: xsd:token ElementType : display-name
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>display-name</code> elements, 
    * a new <code>display-name</code> element 
    * @param values list of <code>display-name</code> objects 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> displayName(String ... values);

   /**
    * Returns all <code>display-name</code> elements
    * @return list of <code>display-name</code> 
    */
   public List<String> getAllDisplayName();

   /**
    * Removes the <code>display-name</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeAllDisplayName();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: javaee:iconType ElementType : icon
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>icon</code> element will be created and returned.
    * Otherwise, the first existing <code>icon</code> element will be returned.
    * @return the instance defined for the element <code>icon</code> 
    */
   public IconType<ConsumerBeanType<T>> getOrCreateIcon();

   /**
    * Creates a new <code>icon</code> element 
    * @return the new created instance of <code>IconType<ConsumerBeanType<T>></code> 
    */
   public IconType<ConsumerBeanType<T>> createIcon();

   /**
    * Returns all <code>icon</code> elements
    * @return list of <code>icon</code> 
    */
   public List<IconType<ConsumerBeanType<T>>> getAllIcon();

   /**
    * Removes all <code>icon</code> elements 
    * @return the current instance of <code>IconType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllIcon();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: javaee:xsdNMTOKENType ElementType : ejb-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>ejb-name</code> element
    * @param ejbName the value for the element <code>ejb-name</code> 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> ejbName(String ejbName);

   /**
    * Returns the <code>ejb-name</code> element
    * @return the node defined for the element <code>ejb-name</code> 
    */
   public String getEjbName();

   /**
    * Removes the <code>ejb-name</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeEjbName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: javaee:fully-qualified-classType ElementType : ejb-class
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>ejb-class</code> element
    * @param ejbClass the value for the element <code>ejb-class</code> 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> ejbClass(String ejbClass);

   /**
    * Returns the <code>ejb-class</code> element
    * @return the node defined for the element <code>ejb-class</code> 
    */
   public String getEjbClass();

   /**
    * Removes the <code>ejb-class</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeEjbClass();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: javaee:string ElementType : message-destination
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>message-destination</code> element
    * @param messageDestination the value for the element <code>message-destination</code> 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> messageDestination(String messageDestination);

   /**
    * Returns the <code>message-destination</code> element
    * @return the node defined for the element <code>message-destination</code> 
    */
   public String getMessageDestination();

   /**
    * Removes the <code>message-destination</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeMessageDestination();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: javaee:fully-qualified-classType ElementType : message-destination-type
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>message-destination-type</code> element
    * @param messageDestinationType the value for the element <code>message-destination-type</code> 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> messageDestinationType(String messageDestinationType);

   /**
    * Returns the <code>message-destination-type</code> element
    * @return the node defined for the element <code>message-destination-type</code> 
    */
   public String getMessageDestinationType();

   /**
    * Removes the <code>message-destination-type</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeMessageDestinationType();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:producerType ElementType : producer
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>producer</code> element will be created and returned.
    * Otherwise, the first existing <code>producer</code> element will be returned.
    * @return the instance defined for the element <code>producer</code> 
    */
   public ProducerType<ConsumerBeanType<T>> getOrCreateProducer();

   /**
    * Creates a new <code>producer</code> element 
    * @return the new created instance of <code>ProducerType<ConsumerBeanType<T>></code> 
    */
   public ProducerType<ConsumerBeanType<T>> createProducer();

   /**
    * Returns all <code>producer</code> elements
    * @return list of <code>producer</code> 
    */
   public List<ProducerType<ConsumerBeanType<T>>> getAllProducer();

   /**
    * Removes all <code>producer</code> elements 
    * @return the current instance of <code>ProducerType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllProducer();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:producerType ElementType : local-producer
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>local-producer</code> element will be created and returned.
    * Otherwise, the first existing <code>local-producer</code> element will be returned.
    * @return the instance defined for the element <code>local-producer</code> 
    */
   public ProducerType<ConsumerBeanType<T>> getOrCreateLocalProducer();

   /**
    * Creates a new <code>local-producer</code> element 
    * @return the new created instance of <code>ProducerType<ConsumerBeanType<T>></code> 
    */
   public ProducerType<ConsumerBeanType<T>> createLocalProducer();

   /**
    * Returns all <code>local-producer</code> elements
    * @return list of <code>local-producer</code> 
    */
   public List<ProducerType<ConsumerBeanType<T>>> getAllLocalProducer();

   /**
    * Removes all <code>local-producer</code> elements 
    * @return the current instance of <code>ProducerType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllLocalProducer();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:method-attributesType ElementType : current-message
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>current-message</code> element with the given value will be created.
    * Otherwise, the existing <code>current-message</code> element will be returned.
    * @return  a new or existing instance of <code>MethodAttributesType<ConsumerBeanType<T>></code> 
    */
   public MethodAttributesType<ConsumerBeanType<T>> getOrCreateCurrentMessage();

   /**
    * Removes the <code>current-message</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeCurrentMessage();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:message-propertiesType ElementType : message-properties
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>message-properties</code> element will be created and returned.
    * Otherwise, the first existing <code>message-properties</code> element will be returned.
    * @return the instance defined for the element <code>message-properties</code> 
    */
   public MessagePropertiesType<ConsumerBeanType<T>> getOrCreateMessageProperties();

   /**
    * Creates a new <code>message-properties</code> element 
    * @return the new created instance of <code>MessagePropertiesType<ConsumerBeanType<T>></code> 
    */
   public MessagePropertiesType<ConsumerBeanType<T>> createMessageProperties();

   /**
    * Returns all <code>message-properties</code> elements
    * @return list of <code>message-properties</code> 
    */
   public List<MessagePropertiesType<ConsumerBeanType<T>>> getAllMessageProperties();

   /**
    * Removes all <code>message-properties</code> elements 
    * @return the current instance of <code>MessagePropertiesType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllMessageProperties();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:ejb-refType ElementType : ejb-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ejb-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>ejb-ref</code> element will be returned.
    * @return the instance defined for the element <code>ejb-ref</code> 
    */
   public EjbRefType<ConsumerBeanType<T>> getOrCreateEjbRef();

   /**
    * Creates a new <code>ejb-ref</code> element 
    * @return the new created instance of <code>EjbRefType<ConsumerBeanType<T>></code> 
    */
   public EjbRefType<ConsumerBeanType<T>> createEjbRef();

   /**
    * Returns all <code>ejb-ref</code> elements
    * @return list of <code>ejb-ref</code> 
    */
   public List<EjbRefType<ConsumerBeanType<T>>> getAllEjbRef();

   /**
    * Removes all <code>ejb-ref</code> elements 
    * @return the current instance of <code>EjbRefType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllEjbRef();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:ejb-local-refType ElementType : ejb-local-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ejb-local-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>ejb-local-ref</code> element will be returned.
    * @return the instance defined for the element <code>ejb-local-ref</code> 
    */
   public EjbLocalRefType<ConsumerBeanType<T>> getOrCreateEjbLocalRef();

   /**
    * Creates a new <code>ejb-local-ref</code> element 
    * @return the new created instance of <code>EjbLocalRefType<ConsumerBeanType<T>></code> 
    */
   public EjbLocalRefType<ConsumerBeanType<T>> createEjbLocalRef();

   /**
    * Returns all <code>ejb-local-ref</code> elements
    * @return list of <code>ejb-local-ref</code> 
    */
   public List<EjbLocalRefType<ConsumerBeanType<T>>> getAllEjbLocalRef();

   /**
    * Removes all <code>ejb-local-ref</code> elements 
    * @return the current instance of <code>EjbLocalRefType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllEjbLocalRef();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:security-identityType ElementType : security-identity
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>security-identity</code> element with the given value will be created.
    * Otherwise, the existing <code>security-identity</code> element will be returned.
    * @return  a new or existing instance of <code>SecurityIdentityType<ConsumerBeanType<T>></code> 
    */
   public SecurityIdentityType<ConsumerBeanType<T>> getOrCreateSecurityIdentity();

   /**
    * Removes the <code>security-identity</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeSecurityIdentity();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:resource-refType ElementType : resource-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>resource-ref</code> element will be returned.
    * @return the instance defined for the element <code>resource-ref</code> 
    */
   public ResourceRefType<ConsumerBeanType<T>> getOrCreateResourceRef();

   /**
    * Creates a new <code>resource-ref</code> element 
    * @return the new created instance of <code>ResourceRefType<ConsumerBeanType<T>></code> 
    */
   public ResourceRefType<ConsumerBeanType<T>> createResourceRef();

   /**
    * Returns all <code>resource-ref</code> elements
    * @return list of <code>resource-ref</code> 
    */
   public List<ResourceRefType<ConsumerBeanType<T>>> getAllResourceRef();

   /**
    * Removes all <code>resource-ref</code> elements 
    * @return the current instance of <code>ResourceRefType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllResourceRef();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:resource-env-refType ElementType : resource-env-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-env-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>resource-env-ref</code> element will be returned.
    * @return the instance defined for the element <code>resource-env-ref</code> 
    */
   public ResourceEnvRefType<ConsumerBeanType<T>> getOrCreateResourceEnvRef();

   /**
    * Creates a new <code>resource-env-ref</code> element 
    * @return the new created instance of <code>ResourceEnvRefType<ConsumerBeanType<T>></code> 
    */
   public ResourceEnvRefType<ConsumerBeanType<T>> createResourceEnvRef();

   /**
    * Returns all <code>resource-env-ref</code> elements
    * @return list of <code>resource-env-ref</code> 
    */
   public List<ResourceEnvRefType<ConsumerBeanType<T>>> getAllResourceEnvRef();

   /**
    * Removes all <code>resource-env-ref</code> elements 
    * @return the current instance of <code>ResourceEnvRefType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllResourceEnvRef();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:message-destination-refType ElementType : message-destination-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>message-destination-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>message-destination-ref</code> element will be returned.
    * @return the instance defined for the element <code>message-destination-ref</code> 
    */
   public MessageDestinationRefType<ConsumerBeanType<T>> getOrCreateMessageDestinationRef();

   /**
    * Creates a new <code>message-destination-ref</code> element 
    * @return the new created instance of <code>MessageDestinationRefType<ConsumerBeanType<T>></code> 
    */
   public MessageDestinationRefType<ConsumerBeanType<T>> createMessageDestinationRef();

   /**
    * Returns all <code>message-destination-ref</code> elements
    * @return list of <code>message-destination-ref</code> 
    */
   public List<MessageDestinationRefType<ConsumerBeanType<T>>> getAllMessageDestinationRef();

   /**
    * Removes all <code>message-destination-ref</code> elements 
    * @return the current instance of <code>MessageDestinationRefType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllMessageDestinationRef();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: xsd:token ElementType : security-domain
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>security-domain</code> element
    * @param securityDomain the value for the element <code>security-domain</code> 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> securityDomain(String securityDomain);

   /**
    * Returns the <code>security-domain</code> element
    * @return the node defined for the element <code>security-domain</code> 
    */
   public String getSecurityDomain();

   /**
    * Removes the <code>security-domain</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeSecurityDomain();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:method-attributesType ElementType : method-attributes
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>method-attributes</code> element with the given value will be created.
    * Otherwise, the existing <code>method-attributes</code> element will be returned.
    * @return  a new or existing instance of <code>MethodAttributesType<ConsumerBeanType<T>></code> 
    */
   public MethodAttributesType<ConsumerBeanType<T>> getOrCreateMethodAttributes();

   /**
    * Removes the <code>method-attributes</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeMethodAttributes();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: xsd:token ElementType : depends
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>depends</code> elements, 
    * a new <code>depends</code> element 
    * @param values list of <code>depends</code> objects 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> depends(String ... values);

   /**
    * Returns all <code>depends</code> elements
    * @return list of <code>depends</code> 
    */
   public List<String> getAllDepends();

   /**
    * Removes the <code>depends</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeAllDepends();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:annotationType ElementType : annotation
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>annotation</code> element will be created and returned.
    * Otherwise, the first existing <code>annotation</code> element will be returned.
    * @return the instance defined for the element <code>annotation</code> 
    */
   public AnnotationType<ConsumerBeanType<T>> getOrCreateAnnotation();

   /**
    * Creates a new <code>annotation</code> element 
    * @return the new created instance of <code>AnnotationType<ConsumerBeanType<T>></code> 
    */
   public AnnotationType<ConsumerBeanType<T>> createAnnotation();

   /**
    * Returns all <code>annotation</code> elements
    * @return list of <code>annotation</code> 
    */
   public List<AnnotationType<ConsumerBeanType<T>>> getAllAnnotation();

   /**
    * Removes all <code>annotation</code> elements 
    * @return the current instance of <code>AnnotationType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllAnnotation();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:ignore-dependencyType ElementType : ignore-dependency
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ignore-dependency</code> element with the given value will be created.
    * Otherwise, the existing <code>ignore-dependency</code> element will be returned.
    * @return  a new or existing instance of <code>IgnoreDependencyType<ConsumerBeanType<T>></code> 
    */
   public IgnoreDependencyType<ConsumerBeanType<T>> getOrCreateIgnoreDependency();

   /**
    * Removes the <code>ignore-dependency</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeIgnoreDependency();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: javaee:string ElementType : aop-domain-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>aop-domain-name</code> element
    * @param aopDomainName the value for the element <code>aop-domain-name</code> 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> aopDomainName(String aopDomainName);

   /**
    * Returns the <code>aop-domain-name</code> element
    * @return the node defined for the element <code>aop-domain-name</code> 
    */
   public String getAopDomainName();

   /**
    * Removes the <code>aop-domain-name</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeAopDomainName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:pool-configType ElementType : pool-config
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>pool-config</code> element with the given value will be created.
    * Otherwise, the existing <code>pool-config</code> element will be returned.
    * @return  a new or existing instance of <code>PoolConfigType<ConsumerBeanType<T>></code> 
    */
   public PoolConfigType<ConsumerBeanType<T>> getOrCreatePoolConfig();

   /**
    * Removes the <code>pool-config</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removePoolConfig();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:jndi-refType ElementType : jndi-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>jndi-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>jndi-ref</code> element will be returned.
    * @return the instance defined for the element <code>jndi-ref</code> 
    */
   public JndiRefType<ConsumerBeanType<T>> getOrCreateJndiRef();

   /**
    * Creates a new <code>jndi-ref</code> element 
    * @return the new created instance of <code>JndiRefType<ConsumerBeanType<T>></code> 
    */
   public JndiRefType<ConsumerBeanType<T>> createJndiRef();

   /**
    * Returns all <code>jndi-ref</code> elements
    * @return list of <code>jndi-ref</code> 
    */
   public List<JndiRefType<ConsumerBeanType<T>>> getAllJndiRef();

   /**
    * Removes all <code>jndi-ref</code> elements 
    * @return the current instance of <code>JndiRefType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllJndiRef();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:activation-configType ElementType : activation-config
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>activation-config</code> element with the given value will be created.
    * Otherwise, the existing <code>activation-config</code> element will be returned.
    * @return  a new or existing instance of <code>ActivationConfigType<ConsumerBeanType<T>></code> 
    */
   public ActivationConfigType<ConsumerBeanType<T>> getOrCreateActivationConfig();

   /**
    * Removes the <code>activation-config</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeActivationConfig();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> id(String id);

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
   public String getId();

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeId();
}
