package org.jboss.shrinkwrap.descriptor.api.jboss51; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.InjectionTargetType;
/**
 * This interface defines the contract for the <code> jndi-refType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface JndiRefType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JndiRefType ElementName: xsd:token ElementType : jndi-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>jndi-name</code> element
    * @param jndiName the value for the element <code>jndi-name</code> 
    * @return the current instance of <code>JndiRefType<T></code> 
    */
   public JndiRefType<T> jndiName(String jndiName);

   /**
    * Returns the <code>jndi-name</code> element
    * @return the node defined for the element <code>jndi-name</code> 
    */
   public String getJndiName();

   /**
    * Removes the <code>jndi-name</code> element 
    * @return the current instance of <code>JndiRefType<T></code> 
    */
   public JndiRefType<T> removeJndiName();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JndiRefType ElementName: xsd:string ElementType : mapped-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>mapped-name</code> element
    * @param mappedName the value for the element <code>mapped-name</code> 
    * @return the current instance of <code>JndiRefType<T></code> 
    */
   public JndiRefType<T> mappedName(String mappedName);

   /**
    * Returns the <code>mapped-name</code> element
    * @return the node defined for the element <code>mapped-name</code> 
    */
   public String getMappedName();

   /**
    * Removes the <code>mapped-name</code> element 
    * @return the current instance of <code>JndiRefType<T></code> 
    */
   public JndiRefType<T> removeMappedName();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JndiRefType ElementName: jboss:injection-targetType ElementType : injection-target
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>injection-target</code> element will be created and returned.
    * Otherwise, the first existing <code>injection-target</code> element will be returned.
    * @return the instance defined for the element <code>injection-target</code> 
    */
   public InjectionTargetType<JndiRefType<T>> getOrCreateInjectionTarget();

   /**
    * Creates a new <code>injection-target</code> element 
    * @return the new created instance of <code>InjectionTargetType<JndiRefType<T>></code> 
    */
   public InjectionTargetType<JndiRefType<T>> createInjectionTarget();

   /**
    * Returns all <code>injection-target</code> elements
    * @return list of <code>injection-target</code> 
    */
   public List<InjectionTargetType<JndiRefType<T>>> getAllInjectionTarget();

   /**
    * Removes all <code>injection-target</code> elements 
    * @return the current instance of <code>InjectionTargetType<JndiRefType<T>></code> 
    */
   public JndiRefType<T> removeAllInjectionTarget();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JndiRefType ElementName: javaee:emptyType ElementType : ignore-dependency
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>ignore-dependency</code> element 
    * @return the current instance of <code>JndiRefType<T></code> 
    */
   public JndiRefType<T> ignoreDependency();

   /**
    * Removes the <code>ignore-dependency</code> element 
    * @return the current instance of <code>JndiRefType<T></code> 
    */
   public Boolean isIgnoreDependency();

   /**
    * Removes the <code>ignore-dependency</code> element 
    * @return the current instance of <code>JndiRefType<T></code> 
    */
   public JndiRefType<T> removeIgnoreDependency();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JndiRefType ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>JndiRefType<T></code> 
    */
   public JndiRefType<T> description(String ... values);

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
   public List<String> getAllDescription();

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>JndiRefType<T></code> 
    */
   public JndiRefType<T> removeAllDescription();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JndiRefType ElementName: xsd:token ElementType : jndi-ref-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>jndi-ref-name</code> element
    * @param jndiRefName the value for the element <code>jndi-ref-name</code> 
    * @return the current instance of <code>JndiRefType<T></code> 
    */
   public JndiRefType<T> jndiRefName(String jndiRefName);

   /**
    * Returns the <code>jndi-ref-name</code> element
    * @return the node defined for the element <code>jndi-ref-name</code> 
    */
   public String getJndiRefName();

   /**
    * Removes the <code>jndi-ref-name</code> element 
    * @return the current instance of <code>JndiRefType<T></code> 
    */
   public JndiRefType<T> removeJndiRefName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JndiRefType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>JndiRefType<T></code> 
    */
   public JndiRefType<T> id(String id);

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
   public String getId();

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>JndiRefType<T></code> 
    */
   public JndiRefType<T> removeId();
}
