package org.jboss.shrinkwrap.descriptor.api.jbosscommon60; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.StubPropertyType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.CallPropertyType;
/**
 * This interface defines the contract for the <code> port-component-refType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface PortComponentRefType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentRefType ElementName: xsd:string ElementType : service-endpoint-interface
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>service-endpoint-interface</code> element
    * @param serviceEndpointInterface the value for the element <code>service-endpoint-interface</code> 
    * @return the current instance of <code>PortComponentRefType<T></code> 
    */
   public PortComponentRefType<T> serviceEndpointInterface(String serviceEndpointInterface);

   /**
    * Returns the <code>service-endpoint-interface</code> element
    * @return the node defined for the element <code>service-endpoint-interface</code> 
    */
   public String getServiceEndpointInterface();

   /**
    * Removes the <code>service-endpoint-interface</code> element 
    * @return the current instance of <code>PortComponentRefType<T></code> 
    */
   public PortComponentRefType<T> removeServiceEndpointInterface();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentRefType ElementName: xsd:string ElementType : port-qname
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>port-qname</code> element
    * @param portQname the value for the element <code>port-qname</code> 
    * @return the current instance of <code>PortComponentRefType<T></code> 
    */
   public PortComponentRefType<T> portQname(String portQname);

   /**
    * Returns the <code>port-qname</code> element
    * @return the node defined for the element <code>port-qname</code> 
    */
   public String getPortQname();

   /**
    * Removes the <code>port-qname</code> element 
    * @return the current instance of <code>PortComponentRefType<T></code> 
    */
   public PortComponentRefType<T> removePortQname();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentRefType ElementName: xsd:string ElementType : config-name
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>config-name</code> element
    * @param configName the value for the element <code>config-name</code> 
    * @return the current instance of <code>PortComponentRefType<T></code> 
    */
   public PortComponentRefType<T> configName(String configName);

   /**
    * Returns the <code>config-name</code> element
    * @return the node defined for the element <code>config-name</code> 
    */
   public String getConfigName();

   /**
    * Removes the <code>config-name</code> element 
    * @return the current instance of <code>PortComponentRefType<T></code> 
    */
   public PortComponentRefType<T> removeConfigName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentRefType ElementName: xsd:string ElementType : config-file
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>config-file</code> element
    * @param configFile the value for the element <code>config-file</code> 
    * @return the current instance of <code>PortComponentRefType<T></code> 
    */
   public PortComponentRefType<T> configFile(String configFile);

   /**
    * Returns the <code>config-file</code> element
    * @return the node defined for the element <code>config-file</code> 
    */
   public String getConfigFile();

   /**
    * Removes the <code>config-file</code> element 
    * @return the current instance of <code>PortComponentRefType<T></code> 
    */
   public PortComponentRefType<T> removeConfigFile();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentRefType ElementName: jboss:stub-propertyType ElementType : stub-property
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>stub-property</code> element will be created and returned.
    * Otherwise, the first existing <code>stub-property</code> element will be returned.
    * @return the instance defined for the element <code>stub-property</code> 
    */
   public StubPropertyType<PortComponentRefType<T>> getOrCreateStubProperty();

   /**
    * Creates a new <code>stub-property</code> element 
    * @return the new created instance of <code>StubPropertyType<PortComponentRefType<T>></code> 
    */
   public StubPropertyType<PortComponentRefType<T>> createStubProperty();

   /**
    * Returns all <code>stub-property</code> elements
    * @return list of <code>stub-property</code> 
    */
   public List<StubPropertyType<PortComponentRefType<T>>> getAllStubProperty();

   /**
    * Removes all <code>stub-property</code> elements 
    * @return the current instance of <code>StubPropertyType<PortComponentRefType<T>></code> 
    */
   public PortComponentRefType<T> removeAllStubProperty();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentRefType ElementName: jboss:call-propertyType ElementType : call-property
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>call-property</code> element will be created and returned.
    * Otherwise, the first existing <code>call-property</code> element will be returned.
    * @return the instance defined for the element <code>call-property</code> 
    */
   public CallPropertyType<PortComponentRefType<T>> getOrCreateCallProperty();

   /**
    * Creates a new <code>call-property</code> element 
    * @return the new created instance of <code>CallPropertyType<PortComponentRefType<T>></code> 
    */
   public CallPropertyType<PortComponentRefType<T>> createCallProperty();

   /**
    * Returns all <code>call-property</code> elements
    * @return list of <code>call-property</code> 
    */
   public List<CallPropertyType<PortComponentRefType<T>>> getAllCallProperty();

   /**
    * Removes all <code>call-property</code> elements 
    * @return the current instance of <code>CallPropertyType<PortComponentRefType<T>></code> 
    */
   public PortComponentRefType<T> removeAllCallProperty();
}
