package org.jboss.shrinkwrap.descriptor.api.jbossdeployment13; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
/**
 * This interface defines the contract for the <code> localLast </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface LocalLast<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: LocalLast ElementName: xsd:boolean ElementType : value
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>value</code> attribute
    * @param value the value for the attribute <code>value</code> 
    * @return the current instance of <code>LocalLast<T></code> 
    */
   public LocalLast<T> value(Boolean value);

   /**
    * Returns the <code>value</code> attribute
    * @return the value defined for the attribute <code>value</code> 
    */
public Boolean isValue();

   /**
    * Removes the <code>value</code> attribute 
    * @return the current instance of <code>LocalLast<T></code> 
    */
   public LocalLast<T> removeValue();
}
