package org.jboss.shrinkwrap.descriptor.api.jbossmodule13; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
/**
 * This interface defines the contract for the <code> pathSpecType </code> xsd type 
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface PathSpecType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PathSpecType ElementName: xsd:string ElementType : path
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>path</code> attribute
    * @param path the value for the attribute <code>path</code> 
    * @return the current instance of <code>PathSpecType<T></code> 
    */
   public PathSpecType<T> path(String path);

   /**
    * Returns the <code>path</code> attribute
    * @return the value defined for the attribute <code>path</code> 
    */
   public String getPath();

   /**
    * Removes the <code>path</code> attribute 
    * @return the current instance of <code>PathSpecType<T></code> 
    */
   public PathSpecType<T> removePath();
}
