package org.jboss.shrinkwrap.descriptor.api.jbossmodule15; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.FilterType;
/**
 * This interface defines the contract for the <code> artifactType </code> xsd type 
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ArtifactType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ArtifactType ElementName: jboss:filterType ElementType : filter
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>filter</code> element with the given value will be created.
    * Otherwise, the existing <code>filter</code> element will be returned.
    * @return  a new or existing instance of <code>FilterType<ArtifactType<T>></code> 
    */
   public FilterType<ArtifactType<T>> getOrCreateFilter();

   /**
    * Removes the <code>filter</code> element 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> removeFilter();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ArtifactType ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> name(String name);

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
   public String getName();

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> removeName();
}
