package org.jboss.shrinkwrap.descriptor.api.jbossweb60; 

/**
 * This class implements the <code> replication-granularityType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public enum ReplicationGranularityType
{
   _SESSION("SESSION"),
   _ATTRIBUTE("ATTRIBUTE");

   private String value;

   ReplicationGranularityType (String value) { this.value = value; }

   public String toString() {return value;}

   public static ReplicationGranularityType getFromStringValue(String value)
   {
      for(ReplicationGranularityType type: ReplicationGranularityType.values())
      {
         if(value != null && type.toString().equals(value))
        { return type;}
      }
      return null;
   }

}

