package org.jboss.shrinkwrap.descriptor.api.jbossweb60; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.webcommon30.TransportGuaranteeType;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.HttpMethodConstraintType;
/**
 * This interface defines the contract for the <code> servlet-securityType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ServletSecurityType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServletSecurityType ElementName: xsd:token ElementType : empty-role-semantic
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>empty-role-semantic</code> element
    * @param emptyRoleSemantic the value for the element <code>empty-role-semantic</code> 
    * @return the current instance of <code>ServletSecurityType<T></code> 
    */
   public ServletSecurityType<T> emptyRoleSemantic(String emptyRoleSemantic);

   /**
    * Returns the <code>empty-role-semantic</code> element
    * @return the node defined for the element <code>empty-role-semantic</code> 
    */
   public String getEmptyRoleSemantic();

   /**
    * Removes the <code>empty-role-semantic</code> element 
    * @return the current instance of <code>ServletSecurityType<T></code> 
    */
   public ServletSecurityType<T> removeEmptyRoleSemantic();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServletSecurityType ElementName: javaee:transport-guaranteeType ElementType : transport-guarantee
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>transport-guarantee</code> element
    * @param transportGuarantee the value for the element <code>transport-guarantee</code> 
    * @return the current instance of <code>ServletSecurityType<T></code> 
    */
   public ServletSecurityType<T> transportGuarantee(TransportGuaranteeType transportGuarantee);
   /**
    * Sets the <code>transport-guarantee</code> element
    * @param transportGuarantee the value for the element <code>transport-guarantee</code> 
    * @return the current instance of <code>ServletSecurityType<T></code> 
    */
   public ServletSecurityType<T> transportGuarantee(String transportGuarantee);

   /**
    * Returns the <code>transport-guarantee</code> element
    * @return the value found for the element <code>transport-guarantee</code> 
    */
   public TransportGuaranteeType getTransportGuarantee();

   /**
    * Returns the <code>transport-guarantee</code> element
    * @return the value found for the element <code>transport-guarantee</code> 
    */
   public String  getTransportGuaranteeAsString();

   /**
    * Removes the <code>transport-guarantee</code> attribute 
    * @return the current instance of <code>ServletSecurityType<T></code> 
    */
   public ServletSecurityType<T> removeTransportGuarantee();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServletSecurityType ElementName: xsd:token ElementType : roles-allowed
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>roles-allowed</code> elements, 
    * a new <code>roles-allowed</code> element 
    * @param values list of <code>roles-allowed</code> objects 
    * @return the current instance of <code>ServletSecurityType<T></code> 
    */
   public ServletSecurityType<T> rolesAllowed(String ... values);

   /**
    * Returns all <code>roles-allowed</code> elements
    * @return list of <code>roles-allowed</code> 
    */
   public List<String> getAllRolesAllowed();

   /**
    * Removes the <code>roles-allowed</code> element 
    * @return the current instance of <code>ServletSecurityType<T></code> 
    */
   public ServletSecurityType<T> removeAllRolesAllowed();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServletSecurityType ElementName: jboss:http-method-constraintType ElementType : http-method-constraint
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>http-method-constraint</code> element will be created and returned.
    * Otherwise, the first existing <code>http-method-constraint</code> element will be returned.
    * @return the instance defined for the element <code>http-method-constraint</code> 
    */
   public HttpMethodConstraintType<ServletSecurityType<T>> getOrCreateHttpMethodConstraint();

   /**
    * Creates a new <code>http-method-constraint</code> element 
    * @return the new created instance of <code>HttpMethodConstraintType<ServletSecurityType<T>></code> 
    */
   public HttpMethodConstraintType<ServletSecurityType<T>> createHttpMethodConstraint();

   /**
    * Returns all <code>http-method-constraint</code> elements
    * @return list of <code>http-method-constraint</code> 
    */
   public List<HttpMethodConstraintType<ServletSecurityType<T>>> getAllHttpMethodConstraint();

   /**
    * Removes all <code>http-method-constraint</code> elements 
    * @return the current instance of <code>HttpMethodConstraintType<ServletSecurityType<T>></code> 
    */
   public ServletSecurityType<T> removeAllHttpMethodConstraint();
}
