package org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.PropertyType;
/**
 * This interface defines the contract for the <code> config-file-type </code> xsd type 
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ConfigFileType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConfigFileType ElementName: wildfly:property-type ElementType : property
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>property</code> element will be created and returned.
    * Otherwise, the first existing <code>property</code> element will be returned.
    * @return the instance defined for the element <code>property</code> 
    */
   public PropertyType<ConfigFileType<T>> getOrCreateProperty();

   /**
    * Creates a new <code>property</code> element 
    * @return the new created instance of <code>PropertyType<ConfigFileType<T>></code> 
    */
   public PropertyType<ConfigFileType<T>> createProperty();

   /**
    * Returns all <code>property</code> elements
    * @return list of <code>property</code> 
    */
   public List<PropertyType<ConfigFileType<T>>> getAllProperty();

   /**
    * Removes all <code>property</code> elements 
    * @return the current instance of <code>PropertyType<ConfigFileType<T>></code> 
    */
   public ConfigFileType<T> removeAllProperty();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConfigFileType ElementName: xsd:string ElementType : template
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>template</code> attribute
    * @param template the value for the attribute <code>template</code> 
    * @return the current instance of <code>ConfigFileType<T></code> 
    */
   public ConfigFileType<T> template(String template);

   /**
    * Returns the <code>template</code> attribute
    * @return the value defined for the attribute <code>template</code> 
    */
   public String getTemplate();

   /**
    * Removes the <code>template</code> attribute 
    * @return the current instance of <code>ConfigFileType<T></code> 
    */
   public ConfigFileType<T> removeTemplate();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConfigFileType ElementName: xsd:string ElementType : subsystems
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>subsystems</code> attribute
    * @param subsystems the value for the attribute <code>subsystems</code> 
    * @return the current instance of <code>ConfigFileType<T></code> 
    */
   public ConfigFileType<T> subsystems(String subsystems);

   /**
    * Returns the <code>subsystems</code> attribute
    * @return the value defined for the attribute <code>subsystems</code> 
    */
   public String getSubsystems();

   /**
    * Removes the <code>subsystems</code> attribute 
    * @return the current instance of <code>ConfigFileType<T></code> 
    */
   public ConfigFileType<T> removeSubsystems();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConfigFileType ElementName: xsd:string ElementType : output-file
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>output-file</code> attribute
    * @param outputFile the value for the attribute <code>output-file</code> 
    * @return the current instance of <code>ConfigFileType<T></code> 
    */
   public ConfigFileType<T> outputFile(String outputFile);

   /**
    * Returns the <code>output-file</code> attribute
    * @return the value defined for the attribute <code>output-file</code> 
    */
   public String getOutputFile();

   /**
    * Removes the <code>output-file</code> attribute 
    * @return the current instance of <code>ConfigFileType<T></code> 
    */
   public ConfigFileType<T> removeOutputFile();
}
