package org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.DependenciesType;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.ArtifactVersionsType;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.ConfigType;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.CopyArtifactsType;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.FilePermissionsType;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.descriptor.api.DescriptorNamespace;

/** 
 * <p> 
 * This deployment descriptor provides the functionalities as described in the  specification
 * <p> 
 * Example:
 * <p> 
 * <code> 
 *     WildFlyFeaturePackDescriptor descriptor = Descriptors.create(WildFlyFeaturePackDescriptor.class);
 * </code> 
 *
 *
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface WildFlyFeaturePackDescriptor extends Descriptor, DescriptorNamespace<WildFlyFeaturePackDescriptor> {

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WildFlyFeaturePackDescriptor ElementName: wildfly:dependencies-type ElementType : dependencies
   // MaxOccurs: -1  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>dependencies</code> element with the given value will be created.
    * Otherwise, the existing <code>dependencies</code> element will be returned.
    * @return  a new or existing instance of <code>DependenciesType<WildFlyFeaturePackDescriptor></code> 
    */
   public DependenciesType<WildFlyFeaturePackDescriptor> getOrCreateDependencies();

   /**
    * Removes the <code>dependencies</code> element 
    * @return the current instance of <code>WildFlyFeaturePackDescriptor</code> 
    */
   public WildFlyFeaturePackDescriptor removeDependencies();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WildFlyFeaturePackDescriptor ElementName: wildfly:artifact-versions-type ElementType : artifact-versions
   // MaxOccurs: -1  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>artifact-versions</code> element with the given value will be created.
    * Otherwise, the existing <code>artifact-versions</code> element will be returned.
    * @return  a new or existing instance of <code>ArtifactVersionsType<WildFlyFeaturePackDescriptor></code> 
    */
   public ArtifactVersionsType<WildFlyFeaturePackDescriptor> getOrCreateArtifactVersions();

   /**
    * Removes the <code>artifact-versions</code> element 
    * @return the current instance of <code>WildFlyFeaturePackDescriptor</code> 
    */
   public WildFlyFeaturePackDescriptor removeArtifactVersions();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WildFlyFeaturePackDescriptor ElementName: wildfly:config-type ElementType : config
   // MaxOccurs: -1  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>config</code> element with the given value will be created.
    * Otherwise, the existing <code>config</code> element will be returned.
    * @return  a new or existing instance of <code>ConfigType<WildFlyFeaturePackDescriptor></code> 
    */
   public ConfigType<WildFlyFeaturePackDescriptor> getOrCreateConfig();

   /**
    * Removes the <code>config</code> element 
    * @return the current instance of <code>WildFlyFeaturePackDescriptor</code> 
    */
   public WildFlyFeaturePackDescriptor removeConfig();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WildFlyFeaturePackDescriptor ElementName: wildfly:copy-artifacts-type ElementType : copy-artifacts
   // MaxOccurs: -1  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>copy-artifacts</code> element with the given value will be created.
    * Otherwise, the existing <code>copy-artifacts</code> element will be returned.
    * @return  a new or existing instance of <code>CopyArtifactsType<WildFlyFeaturePackDescriptor></code> 
    */
   public CopyArtifactsType<WildFlyFeaturePackDescriptor> getOrCreateCopyArtifacts();

   /**
    * Removes the <code>copy-artifacts</code> element 
    * @return the current instance of <code>WildFlyFeaturePackDescriptor</code> 
    */
   public WildFlyFeaturePackDescriptor removeCopyArtifacts();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WildFlyFeaturePackDescriptor ElementName: wildfly:file-permissions-type ElementType : file-permissions
   // MaxOccurs: -1  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>file-permissions</code> element with the given value will be created.
    * Otherwise, the existing <code>file-permissions</code> element will be returned.
    * @return  a new or existing instance of <code>FilePermissionsType<WildFlyFeaturePackDescriptor></code> 
    */
   public FilePermissionsType<WildFlyFeaturePackDescriptor> getOrCreateFilePermissions();

   /**
    * Removes the <code>file-permissions</code> element 
    * @return the current instance of <code>WildFlyFeaturePackDescriptor</code> 
    */
   public WildFlyFeaturePackDescriptor removeFilePermissions();
}
