/*
 * Decompiled with CFR 0.152.
 */
package org.fluentd.logger.sender;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import org.fluentd.logger.errorhandler.ErrorHandler;
import org.fluentd.logger.sender.Event;
import org.fluentd.logger.sender.ExponentialDelayReconnector;
import org.fluentd.logger.sender.Reconnector;
import org.fluentd.logger.sender.Sender;
import org.msgpack.MessagePack;
import org.msgpack.template.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawSocketSender
implements Sender {
    private static final Logger LOG = LoggerFactory.getLogger(RawSocketSender.class);
    private static final ErrorHandler DEFAULT_ERROR_HANLDER = new ErrorHandler(){};
    private MessagePack msgpack;
    private SocketAddress server;
    private Socket socket;
    private int timeout;
    private BufferedOutputStream out;
    private ByteBuffer pendings;
    private Reconnector reconnector;
    private String name;
    private ErrorHandler errorHandler = DEFAULT_ERROR_HANLDER;

    public RawSocketSender() {
        this("localhost", 24224);
    }

    public RawSocketSender(String host, int port) {
        this(host, port, 3000, 0x800000);
    }

    public RawSocketSender(String host, int port, int timeout, int bufferCapacity) {
        this(host, port, timeout, bufferCapacity, new ExponentialDelayReconnector());
    }

    public RawSocketSender(String host, int port, int timeout, int bufferCapacity, Reconnector reconnector) {
        this.msgpack = new MessagePack();
        this.msgpack.register(Event.class, (Template)Event.EventTemplate.INSTANCE);
        this.pendings = ByteBuffer.allocate(bufferCapacity);
        this.server = new InetSocketAddress(host, port);
        this.reconnector = reconnector;
        this.name = String.format("%s_%d_%d_%d", host, port, timeout, bufferCapacity);
        this.timeout = timeout;
    }

    private void connect() throws IOException {
        this.socket = new Socket();
        this.socket.connect(this.server, this.timeout);
        this.out = new BufferedOutputStream(this.socket.getOutputStream());
    }

    private void reconnect() throws IOException {
        if (this.socket == null) {
            this.connect();
        } else if (this.socket.isClosed() || !this.socket.isConnected()) {
            this.close();
            this.connect();
        }
    }

    @Override
    public void close() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
            }
            finally {
                this.out = null;
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.socket = null;
            }
        }
    }

    @Override
    public boolean emit(String tag, Map<String, Object> data) {
        return this.emit(tag, System.currentTimeMillis() / 1000L, data);
    }

    @Override
    public boolean emit(String tag, long timestamp, Map<String, Object> data) {
        return this.emit(new Event(tag, timestamp, data));
    }

    protected boolean emit(Event event) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("Created %s", event));
        }
        byte[] bytes = null;
        try {
            bytes = this.msgpack.write((Object)event);
        }
        catch (IOException e) {
            LOG.error("Cannot serialize event: " + event, (Throwable)e);
            return false;
        }
        return this.send(bytes);
    }

    private boolean flushBuffer() {
        if (this.reconnector.enableReconnection(System.currentTimeMillis())) {
            this.flush();
            if (this.pendings.position() == 0) {
                return true;
            }
        }
        return false;
    }

    private synchronized boolean send(byte[] bytes) {
        if (this.pendings.position() + bytes.length > this.pendings.capacity() && !this.flushBuffer()) {
            LOG.error("Cannot send logs to " + this.server.toString());
            return false;
        }
        this.pendings.put(bytes);
        if (!this.reconnector.enableReconnection(System.currentTimeMillis())) {
            return true;
        }
        this.flush();
        return true;
    }

    @Override
    public synchronized void flush() {
        try {
            this.reconnect();
            this.out.write(this.getBuffer());
            this.out.flush();
            this.clearBuffer();
            this.reconnector.clearErrorHistory();
        }
        catch (IOException e) {
            try {
                this.errorHandler.handleNetworkError(e);
            }
            catch (Exception handlerException) {
                LOG.warn("ErrorHandler.handleNetworkError failed", (Throwable)handlerException);
            }
            LOG.error(this.getClass().getName(), (Object)"flush", (Object)e);
            this.reconnector.addErrorHistory(System.currentTimeMillis());
            this.close();
        }
    }

    synchronized byte[] getBuffer() {
        int len = this.pendings.position();
        this.pendings.position(0);
        byte[] ret = new byte[len];
        this.pendings.get(ret, 0, len);
        return ret;
    }

    private void clearBuffer() {
        this.pendings.clear();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isConnected() {
        return this.socket != null && !this.socket.isClosed() && this.socket.isConnected() && !this.socket.isOutputShutdown();
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new IllegalArgumentException("errorHandler is null");
        }
        this.errorHandler = errorHandler;
    }

    @Override
    public void removeErrorHandler() {
        this.errorHandler = DEFAULT_ERROR_HANLDER;
    }
}

