/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jaeger.runtime;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.jaeger.JaegerFraction;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;
import org.wildfly.swarm.undertow.WARArchive;
import org.wildfly.swarm.undertow.descriptors.WebXmlAsset;

@DeploymentScoped
public class JaegerInstaller
implements DeploymentProcessor {
    private static final Logger logger = Logger.getLogger(JaegerInstaller.class);
    private final Archive<?> archive;
    @Inject
    private Instance<JaegerFraction> jaegerFractionInstance;

    @Inject
    public JaegerInstaller(Archive archive) {
        this.archive = archive;
    }

    public void process() throws Exception {
        JaegerFraction fraction = (JaegerFraction)this.jaegerFractionInstance.get();
        logger.info((Object)"Determining whether to install Jaeger integration or not.");
        logger.info((Object)("JaegerFraction instance: " + fraction));
        if (this.archive.getName().endsWith(".war")) {
            logger.logf(Logger.Level.INFO, "Installing the Jaeger integration for the deployment %s", (Object)this.archive.getName());
            WARArchive webArchive = (WARArchive)this.archive.as(WARArchive.class);
            WebXmlAsset webXml = webArchive.findWebXmlAsset();
            logger.logf(Logger.Level.INFO, "Adding the listener org.wildfly.swarm.jaeger.deployment.JaegerInitializer", new Object[0]);
            webXml.addListener("org.wildfly.swarm.jaeger.deployment.JaegerInitializer");
            this.setContextParamIfNotNull(webXml, "JAEGER_SERVICE_NAME", fraction.getServiceName());
            this.setContextParamIfNotNull(webXml, "JAEGER_SERVICE_NAME", fraction.getServiceName());
            this.setContextParamIfNotNull(webXml, "JAEGER_SAMPLER_TYPE", fraction.getSamplerType());
            this.setContextParamIfNotNull(webXml, "JAEGER_SAMPLER_PARAM", fraction.getSamplerParameter());
            this.setContextParamIfNotNull(webXml, "JAEGER_SAMPLER_MANAGER_HOST_PORT", fraction.getSamplerManagerHost());
            this.setContextParamIfNotNull(webXml, "JAEGER_REPORTER_LOG_SPANS", fraction.getReporterLogSpans());
            this.setContextParamIfNotNull(webXml, "JAEGER_AGENT_HOST", fraction.getAgentHost());
            this.setContextParamIfNotNull(webXml, "JAEGER_AGENT_PORT", fraction.getAgentPort());
            this.setContextParamIfNotNull(webXml, "JAEGER_REPORTER_FLUSH_INTERVAL", fraction.getReporterFlushInterval());
            this.setContextParamIfNotNull(webXml, "JAEGER_REPORTER_MAX_QUEUE_SIZE", fraction.getReporterMaxQueueSize());
            webXml.setContextParam("skipOpenTracingResolver", new String[]{"true"});
        }
    }

    private void setContextParamIfNotNull(WebXmlAsset webXml, String key, String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        webXml.setContextParam(key, new String[]{value});
    }
}

