/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.util.Arrays;
import java.util.List;
import org.geolatte.geom.G2DM;
import org.geolatte.geom.G3DM;
import org.geolatte.geom.crs.CoordinateSystem;
import org.geolatte.geom.crs.CoordinateSystemAxis;
import org.geolatte.geom.crs.EllipsoidalAxis;
import org.geolatte.geom.crs.EllipsoidalCoordinateSystem3DM;
import org.geolatte.geom.crs.EllipsoidalHeightCSAXis;
import org.geolatte.geom.crs.MeasureStraightLineAxis;
import org.geolatte.geom.crs.OneDimensionCoordinateSystem;
import org.geolatte.geom.crs.VerticalStraightLineAxis;

public class EllipsoidalCoordinateSystem2DM
extends CoordinateSystem<G2DM> {
    private static final List<Integer> REQUIRED_AXIS_NORMAL_ORDER = Arrays.asList(0, 1, 3);

    public EllipsoidalCoordinateSystem2DM(EllipsoidalAxis first, EllipsoidalAxis second, MeasureStraightLineAxis other) {
        super(first, second, other);
        this.checkAxes();
    }

    private void checkAxes() {
        List<Integer> order = this.getAxisNormalOrder();
        if (!order.containsAll(REQUIRED_AXIS_NORMAL_ORDER)) {
            throw new IllegalArgumentException("Require order 0, 1 and 2 axes");
        }
    }

    @Override
    public Class<G2DM> getPositionClass() {
        return G2DM.class;
    }

    @Override
    public CoordinateSystem<?> merge(OneDimensionCoordinateSystem<?> coordinateSystem) {
        CoordinateSystemAxis axis = coordinateSystem.getAxis();
        return this.extend(axis);
    }

    @Override
    public CoordinateSystem<G3DM> extend(CoordinateSystemAxis axis) {
        if (axis instanceof EllipsoidalHeightCSAXis) {
            return new EllipsoidalCoordinateSystem3DM((EllipsoidalAxis)this.getAxis(0), (EllipsoidalAxis)this.getAxis(1), (EllipsoidalHeightCSAXis)axis, (MeasureStraightLineAxis)this.getAxis(2));
        }
        if (axis instanceof VerticalStraightLineAxis) {
            return new EllipsoidalCoordinateSystem3DM((EllipsoidalAxis)this.getAxis(0), (EllipsoidalAxis)this.getAxis(1), (VerticalStraightLineAxis)axis, (MeasureStraightLineAxis)this.getAxis(2));
        }
        throw new UnsupportedOperationException();
    }
}

