/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.SpanCollectorMetricsHandler;
import com.github.kristofa.brave.internal.Nullable;
import com.twitter.zipkin.gen.Span;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

@Deprecated
public abstract class FlushingSpanCollector
implements SpanCollector,
Flushable,
Closeable {
    private final SpanCollectorMetricsHandler metrics;
    private final BlockingQueue<Span> pending = new LinkedBlockingQueue<Span>(1000);
    @Nullable
    private final Flusher flusher;

    protected FlushingSpanCollector(SpanCollectorMetricsHandler metrics, int flushInterval) {
        this.metrics = metrics;
        this.flusher = flushInterval > 0 ? new Flusher(this, flushInterval, this.getClass().getSimpleName()) : null;
    }

    @Override
    public void collect(Span span) {
        this.metrics.incrementAcceptedSpans(1);
        if (!this.pending.offer(span)) {
            this.metrics.incrementDroppedSpans(1);
        }
    }

    @Override
    public void flush() {
        if (this.pending.isEmpty()) {
            return;
        }
        ArrayList<Span> drained = new ArrayList<Span>(this.pending.size());
        this.pending.drainTo(drained);
        if (drained.isEmpty()) {
            return;
        }
        int spanCount = drained.size();
        try {
            this.reportSpans(drained);
        }
        catch (IOException e) {
            this.metrics.incrementDroppedSpans(spanCount);
        }
        catch (RuntimeException e) {
            this.metrics.incrementDroppedSpans(spanCount);
        }
    }

    protected abstract void reportSpans(List<Span> var1) throws IOException;

    @Override
    public void addDefaultAnnotation(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.flusher != null) {
            this.flusher.scheduler.shutdown();
        }
        int dropped = this.pending.drainTo(new LinkedList());
        this.metrics.incrementDroppedSpans(dropped);
    }

    static final class Flusher
    implements Runnable {
        final Flushable flushable;
        final ScheduledExecutorService scheduler;

        Flusher(Flushable flushable, int flushInterval, final String threadPoolName) {
            this.flushable = flushable;
            this.scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, threadPoolName);
                }
            });
            this.scheduler.scheduleWithFixedDelay(this, 0L, flushInterval, TimeUnit.SECONDS);
        }

        @Override
        public void run() {
            try {
                this.flushable.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

