
package zipkin.reporter.urlconnection;

import java.net.URL;
import javax.annotation.Generated;
import zipkin.reporter.BytesMessageEncoder;
import zipkin.reporter.Encoding;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_URLConnectionSender extends URLConnectionSender {

  private final Encoding encoding;
  private final int messageMaxBytes;
  private final BytesMessageEncoder encoder;
  private final URL endpoint;
  private final int connectTimeout;
  private final int readTimeout;
  private final boolean compressionEnabled;
  private final String mediaType;

  private AutoValue_URLConnectionSender(
      Encoding encoding,
      int messageMaxBytes,
      BytesMessageEncoder encoder,
      URL endpoint,
      int connectTimeout,
      int readTimeout,
      boolean compressionEnabled,
      String mediaType) {
    this.encoding = encoding;
    this.messageMaxBytes = messageMaxBytes;
    this.encoder = encoder;
    this.endpoint = endpoint;
    this.connectTimeout = connectTimeout;
    this.readTimeout = readTimeout;
    this.compressionEnabled = compressionEnabled;
    this.mediaType = mediaType;
  }

  @Override
  public Encoding encoding() {
    return encoding;
  }

  @Override
  public int messageMaxBytes() {
    return messageMaxBytes;
  }

  @Override
  BytesMessageEncoder encoder() {
    return encoder;
  }

  @Override
  URL endpoint() {
    return endpoint;
  }

  @Override
  int connectTimeout() {
    return connectTimeout;
  }

  @Override
  int readTimeout() {
    return readTimeout;
  }

  @Override
  boolean compressionEnabled() {
    return compressionEnabled;
  }

  @Override
  String mediaType() {
    return mediaType;
  }

  @Override
  public String toString() {
    return "URLConnectionSender{"
        + "encoding=" + encoding + ", "
        + "messageMaxBytes=" + messageMaxBytes + ", "
        + "encoder=" + encoder + ", "
        + "endpoint=" + endpoint + ", "
        + "connectTimeout=" + connectTimeout + ", "
        + "readTimeout=" + readTimeout + ", "
        + "compressionEnabled=" + compressionEnabled + ", "
        + "mediaType=" + mediaType
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof URLConnectionSender) {
      URLConnectionSender that = (URLConnectionSender) o;
      return (this.encoding.equals(that.encoding()))
           && (this.messageMaxBytes == that.messageMaxBytes())
           && (this.encoder.equals(that.encoder()))
           && (this.endpoint.equals(that.endpoint()))
           && (this.connectTimeout == that.connectTimeout())
           && (this.readTimeout == that.readTimeout())
           && (this.compressionEnabled == that.compressionEnabled())
           && (this.mediaType.equals(that.mediaType()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.encoding.hashCode();
    h *= 1000003;
    h ^= this.messageMaxBytes;
    h *= 1000003;
    h ^= this.encoder.hashCode();
    h *= 1000003;
    h ^= this.endpoint.hashCode();
    h *= 1000003;
    h ^= this.connectTimeout;
    h *= 1000003;
    h ^= this.readTimeout;
    h *= 1000003;
    h ^= this.compressionEnabled ? 1231 : 1237;
    h *= 1000003;
    h ^= this.mediaType.hashCode();
    return h;
  }

  static final class Builder extends URLConnectionSender.Builder {
    private Encoding encoding;
    private Integer messageMaxBytes;
    private BytesMessageEncoder encoder;
    private URL endpoint;
    private Integer connectTimeout;
    private Integer readTimeout;
    private Boolean compressionEnabled;
    private String mediaType;
    Builder() {
    }
    Builder(URLConnectionSender source) {
      this.encoding = source.encoding();
      this.messageMaxBytes = source.messageMaxBytes();
      this.encoder = source.encoder();
      this.endpoint = source.endpoint();
      this.connectTimeout = source.connectTimeout();
      this.readTimeout = source.readTimeout();
      this.compressionEnabled = source.compressionEnabled();
      this.mediaType = source.mediaType();
    }
    @Override
    public URLConnectionSender.Builder encoding(Encoding encoding) {
      this.encoding = encoding;
      return this;
    }
    @Override
    public Encoding encoding() {
      if (encoding == null) {
        throw new IllegalStateException("Property \"encoding\" has not been set");
      }
      return encoding;
    }
    @Override
    public URLConnectionSender.Builder messageMaxBytes(int messageMaxBytes) {
      this.messageMaxBytes = messageMaxBytes;
      return this;
    }
    @Override
    public URLConnectionSender.Builder encoder(BytesMessageEncoder encoder) {
      this.encoder = encoder;
      return this;
    }
    @Override
    public URLConnectionSender.Builder endpoint(URL endpoint) {
      this.endpoint = endpoint;
      return this;
    }
    @Override
    public URLConnectionSender.Builder connectTimeout(int connectTimeout) {
      this.connectTimeout = connectTimeout;
      return this;
    }
    @Override
    public URLConnectionSender.Builder readTimeout(int readTimeout) {
      this.readTimeout = readTimeout;
      return this;
    }
    @Override
    public URLConnectionSender.Builder compressionEnabled(boolean compressionEnabled) {
      this.compressionEnabled = compressionEnabled;
      return this;
    }
    @Override
    public URLConnectionSender.Builder mediaType(String mediaType) {
      this.mediaType = mediaType;
      return this;
    }
    @Override
    public URLConnectionSender autoBuild() {
      String missing = "";
      if (encoding == null) {
        missing += " encoding";
      }
      if (messageMaxBytes == null) {
        missing += " messageMaxBytes";
      }
      if (encoder == null) {
        missing += " encoder";
      }
      if (endpoint == null) {
        missing += " endpoint";
      }
      if (connectTimeout == null) {
        missing += " connectTimeout";
      }
      if (readTimeout == null) {
        missing += " readTimeout";
      }
      if (compressionEnabled == null) {
        missing += " compressionEnabled";
      }
      if (mediaType == null) {
        missing += " mediaType";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_URLConnectionSender(
          this.encoding,
          this.messageMaxBytes,
          this.encoder,
          this.endpoint,
          this.connectTimeout,
          this.readTimeout,
          this.compressionEnabled,
          this.mediaType);
    }
  }

}
