/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.orientdb.Orient;
import org.wildfly.swarm.config.orientdb.OrientConsumer;
import org.wildfly.swarm.config.orientdb.OrientSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=orientdb")
@ResourceType(value="subsystem")
@Implicit
public class Orientdb<T extends Orientdb<T>>
extends HashMap
implements Keyed {
    private String key = "orientdb";
    private PropertyChangeSupport pcs;
    private OrientdbResources subresources = new OrientdbResources();

    public Orientdb() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public OrientdbResources subresources() {
        return this.subresources;
    }

    public T orients(List<Orient> value) {
        this.subresources.orients = value;
        return (T)this;
    }

    public T orient(Orient value) {
        this.subresources.orients.add(value);
        return (T)this;
    }

    public T orient(String childKey, OrientConsumer consumer) {
        Orient child = new Orient(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.orient(child);
        return (T)this;
    }

    public T orient(String childKey) {
        this.orient(childKey, null);
        return (T)this;
    }

    public T orient(OrientSupplier supplier) {
        this.orient(supplier.get());
        return (T)this;
    }

    public static class OrientdbResources {
        @ResourceDocumentation(value="OrientDB server definition")
        @SubresourceInfo(value="orient")
        private List<Orient> orients = new ArrayList<Orient>();

        @Subresource
        public List<Orient> orients() {
            return this.orients;
        }

        public Orient orient(String key) {
            return this.orients.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

