/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.jaxrs2;

import com.github.kristofa.brave.ClientRequestAdapter;
import com.github.kristofa.brave.ClientRequestInterceptor;
import com.github.kristofa.brave.http.HttpClientRequest;
import com.github.kristofa.brave.http.HttpClientRequestAdapter;
import com.github.kristofa.brave.http.SpanNameProvider;
import com.github.kristofa.brave.jaxrs2.JaxRs2HttpClientRequest;
import java.io.IOException;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(value=0)
public class BraveClientRequestFilter
implements ClientRequestFilter {
    private final ClientRequestInterceptor requestInterceptor;
    private final SpanNameProvider spanNameProvider;

    @Inject
    public BraveClientRequestFilter(SpanNameProvider spanNameProvider, ClientRequestInterceptor requestInterceptor) {
        this.requestInterceptor = requestInterceptor;
        this.spanNameProvider = spanNameProvider;
    }

    public void filter(ClientRequestContext clientRequestContext) throws IOException {
        JaxRs2HttpClientRequest req = new JaxRs2HttpClientRequest(clientRequestContext);
        this.requestInterceptor.handle((ClientRequestAdapter)new HttpClientRequestAdapter((HttpClientRequest)req, this.spanNameProvider));
    }
}

