/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.jaxrs2;

import com.github.kristofa.brave.ServerRequestAdapter;
import com.github.kristofa.brave.ServerRequestInterceptor;
import com.github.kristofa.brave.http.HttpServerRequest;
import com.github.kristofa.brave.http.HttpServerRequestAdapter;
import com.github.kristofa.brave.http.SpanNameProvider;
import com.github.kristofa.brave.jaxrs2.JaxRs2HttpServerRequest;
import java.io.IOException;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;

@Provider
@PreMatching
@Priority(value=0)
public class BraveContainerRequestFilter
implements ContainerRequestFilter {
    private final ServerRequestInterceptor requestInterceptor;
    private final SpanNameProvider spanNameProvider;

    @Inject
    public BraveContainerRequestFilter(ServerRequestInterceptor interceptor, SpanNameProvider spanNameProvider) {
        this.requestInterceptor = interceptor;
        this.spanNameProvider = spanNameProvider;
    }

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        JaxRs2HttpServerRequest request = new JaxRs2HttpServerRequest(containerRequestContext);
        this.requestInterceptor.handle((ServerRequestAdapter)new HttpServerRequestAdapter((HttpServerRequest)request, this.spanNameProvider));
    }
}

