/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexCursorCollectionValue;
import com.orientechnologies.orient.core.index.OIndexCursorSingleValue;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquality;
import java.util.Collection;
import java.util.List;

public class OQueryOperatorIs
extends OQueryOperatorEquality {
    public OQueryOperatorIs() {
        super("IS", 5, false);
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        if ("_NOT_NULL_".equals(iRight)) {
            return iLeft != null;
        }
        if ("_NOT_NULL_".equals(iLeft)) {
            return iRight != null;
        }
        if ("_DEFINED_".equals(iLeft)) {
            return this.evaluateDefined(iRecord, (String)iRight);
        }
        if ("_DEFINED_".equals(iRight)) {
            return this.evaluateDefined(iRecord, (String)iLeft);
        }
        return iLeft == iRight;
    }

    protected boolean evaluateDefined(OIdentifiable iRecord, String iFieldName) {
        if (iRecord instanceof ODocument) {
            return ((ODocument)iRecord).containsField(iFieldName);
        }
        return false;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        if (iRight == null) {
            return OIndexReuseType.INDEX_METHOD;
        }
        return OIndexReuseType.NO_INDEX;
    }

    @Override
    public OIndexCursor executeIndexQuery(OCommandContext iContext, OIndex<?> index, List<Object> keyParams, boolean ascSortOrder) {
        OIndexCursor cursor;
        OIndexDefinition indexDefinition = index.getDefinition();
        OIndexInternal<?> internalIndex = index.getInternal();
        if (!internalIndex.canBeUsedInEqualityOperators()) {
            return null;
        }
        if (indexDefinition.getParamCount() == 1) {
            Object key = indexDefinition instanceof OIndexDefinitionMultiValue ? ((OIndexDefinitionMultiValue)indexDefinition).createSingleValue(keyParams.get(0)) : indexDefinition.createValue(keyParams);
            Object indexResult = index.get(key);
            cursor = indexResult == null || indexResult instanceof OIdentifiable ? new OIndexCursorSingleValue((OIdentifiable)indexResult, key) : new OIndexCursorCollectionValue((Collection)indexResult, key);
        } else {
            OCompositeIndexDefinition compositeIndexDefinition = (OCompositeIndexDefinition)indexDefinition;
            OCompositeKey keyOne = compositeIndexDefinition.createSingleValue(keyParams);
            OCompositeKey keyTwo = compositeIndexDefinition.createSingleValue(keyParams);
            if (internalIndex.hasRangeQuerySupport()) {
                cursor = index.iterateEntriesBetween(keyOne, true, keyTwo, true, ascSortOrder);
            } else if (indexDefinition.getParamCount() == keyParams.size()) {
                Object indexResult = index.get(keyOne);
                cursor = indexResult == null || indexResult instanceof OIdentifiable ? new OIndexCursorSingleValue((OIdentifiable)indexResult, keyOne) : new OIndexCursorCollectionValue((Collection)indexResult, keyOne);
            } else {
                return null;
            }
        }
        this.updateProfiler(iContext, index, keyParams, indexDefinition);
        return cursor;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

