/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.msc.internal;

import org.jboss.msc.service.ServiceActivator;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.ArchiveBase;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.wildfly.swarm.msc.ServiceActivatorArchive;
import org.wildfly.swarm.msc.internal.ServiceActivatorAsset;

public final class ServiceActivatorArchiveImpl
extends AssignableBase<ArchiveBase<?>>
implements ServiceActivatorArchive {
    private ServiceActivatorAsset asset;

    public ServiceActivatorArchiveImpl(ArchiveBase<?> archive) {
        super(archive);
        this.prepareAsset();
    }

    private String path() {
        if (((ArchiveBase)this.getArchive()).getName().endsWith(".war")) {
            return "WEB-INF/classes/META-INF/services/" + ServiceActivator.class.getName();
        }
        return "META-INF/services/" + ServiceActivator.class.getName();
    }

    @Override
    public ServiceActivatorAsset getAsset() {
        return this.asset;
    }

    @Override
    public ServiceActivatorArchive setAsset(ServiceActivatorAsset asset) {
        this.asset = asset;
        ((ArchiveBase)this.getArchive()).add((Asset)this.asset, this.path());
        return this;
    }

    protected void prepareAsset() {
        Node node = ((ArchiveBase)this.getArchive()).get(this.path());
        if (node != null) {
            Asset maybeCorrect = node.getAsset();
            if (maybeCorrect instanceof ServiceActivatorAsset) {
                this.setAsset((ServiceActivatorAsset)maybeCorrect);
            } else {
                ServiceActivatorAsset read = new ServiceActivatorAsset(maybeCorrect.openStream());
                this.setAsset(read);
            }
        } else {
            this.setAsset(new ServiceActivatorAsset());
        }
    }

    @Override
    public ServiceActivatorArchive addServiceActivator(Class<? extends ServiceActivator> cls) {
        if (((ArchiveBase)this.getArchive()).getName().endsWith(".war")) {
            ((WebArchive)((ArchiveBase)this.getArchive()).as(WebArchive.class)).addClass(cls);
        } else if (((ArchiveBase)this.getArchive()).getName().endsWith(".jar")) {
            ((JavaArchive)((ArchiveBase)this.getArchive()).as(JavaArchive.class)).addClass(cls);
        }
        this.asset.addServiceActivator(cls);
        return this;
    }

    @Override
    public ServiceActivatorArchive addServiceActivator(String className) {
        this.asset.addServiceActivator(className);
        return this;
    }

    @Override
    public boolean containsServiceActivator(String className) {
        return this.asset.containsServiceActivator(className);
    }
}

