/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.nio.ByteBuffer;
import java.util.List;
import zipkin.DependencyLink;
import zipkin.internal.Buffer;
import zipkin.internal.ThriftCodec;
import zipkin.internal.Util;

@Deprecated
public final class Dependencies {
    public final long startTs;
    public final long endTs;
    public final List<DependencyLink> links;
    @Deprecated
    static final ThriftCodec.ThriftAdapter<Dependencies> THRIFT_ADAPTER = new ThriftCodec.ThriftAdapter<Dependencies>(){
        final ThriftCodec.Field START_TS = new ThriftCodec.Field(10, 1);
        final ThriftCodec.Field END_TS = new ThriftCodec.Field(10, 2);
        final ThriftCodec.Field LINKS = new ThriftCodec.Field(15, 3);

        @Override
        public Dependencies read(ByteBuffer bytes) {
            long startTs = 0L;
            long endTs = 0L;
            List links = null;
            while (true) {
                ThriftCodec.Field field = ThriftCodec.Field.read(bytes);
                if (field.type == 0) break;
                if (field.isEqualTo(this.START_TS)) {
                    startTs = bytes.getLong();
                    continue;
                }
                if (field.isEqualTo(this.END_TS)) {
                    endTs = bytes.getLong();
                    continue;
                }
                if (field.isEqualTo(this.LINKS)) {
                    links = (List)ThriftCodec.DEPENDENCY_LINKS_ADAPTER.read(bytes);
                    continue;
                }
                ThriftCodec.skip(bytes, field.type);
            }
            return Dependencies.create(startTs, endTs, links);
        }

        @Override
        public int sizeInBytes(Dependencies value) {
            int sizeInBytes = 0;
            sizeInBytes += 11;
            sizeInBytes += 11;
            sizeInBytes += 3 + ThriftCodec.DEPENDENCY_LINKS_ADAPTER.sizeInBytes(value.links);
            return ++sizeInBytes;
        }

        @Override
        public void write(Dependencies value, Buffer buffer) {
            this.START_TS.write(buffer);
            buffer.writeLong(value.startTs);
            this.END_TS.write(buffer);
            buffer.writeLong(value.endTs);
            this.LINKS.write(buffer);
            ThriftCodec.DEPENDENCY_LINKS_ADAPTER.write(value.links, buffer);
            buffer.writeByte(0);
        }

        public String toString() {
            return "Dependencies";
        }
    };

    public static Dependencies fromThrift(ByteBuffer bytes) {
        return ThriftCodec.read(THRIFT_ADAPTER, bytes);
    }

    public ByteBuffer toThrift() {
        return ByteBuffer.wrap(ThriftCodec.write(THRIFT_ADAPTER, this));
    }

    public static Dependencies create(long startTs, long endTs, List<DependencyLink> links) {
        return new Dependencies(startTs, endTs, links);
    }

    Dependencies(long startTs, long endTs, List<DependencyLink> links) {
        this.startTs = startTs;
        this.endTs = endTs;
        this.links = Util.checkNotNull(links, "links");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Dependencies) {
            Dependencies that = (Dependencies)o;
            return this.startTs == that.startTs && this.endTs == that.endTs && this.links.equals(that.links);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h = (int)((long)h ^ (this.startTs >>> 32 ^ this.startTs));
        h *= 1000003;
        h = (int)((long)h ^ (this.endTs >>> 32 ^ this.endTs));
        h *= 1000003;
        return h ^= this.links.hashCode();
    }
}

