/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.oracle;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.dbsupport.Table;
import org.flywaydb.core.internal.dbsupport.oracle.OracleDbSupport;
import org.flywaydb.core.internal.dbsupport.oracle.OracleTable;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;

public class OracleSchema
extends Schema<OracleDbSupport> {
    private static final Log LOG = LogFactory.getLog(OracleSchema.class);

    public OracleSchema(JdbcTemplate jdbcTemplate, OracleDbSupport dbSupport, String name) {
        super(jdbcTemplate, dbSupport, name);
    }

    protected boolean isSystem() throws SQLException {
        return ((OracleDbSupport)this.dbSupport).getSystemSchemas().contains(this.name);
    }

    protected boolean isDefaultSchemaForUser() throws SQLException {
        return this.name.equals(((OracleDbSupport)this.dbSupport).getCurrentUserName());
    }

    @Override
    protected boolean doExists() throws SQLException {
        return ((OracleDbSupport)this.dbSupport).queryReturnsRows("SELECT * FROM ALL_USERS WHERE USERNAME = ?", this.name);
    }

    @Override
    protected boolean doEmpty() throws SQLException {
        return !((OracleDbSupport)this.dbSupport).queryReturnsRows("SELECT * FROM ALL_OBJECTS WHERE OWNER = ?", this.name);
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE USER " + ((OracleDbSupport)this.dbSupport).quote(this.name) + " IDENTIFIED BY flyway", new Object[0]);
        this.jdbcTemplate.execute("GRANT RESOURCE TO " + ((OracleDbSupport)this.dbSupport).quote(this.name), new Object[0]);
        this.jdbcTemplate.execute("GRANT UNLIMITED TABLESPACE TO " + ((OracleDbSupport)this.dbSupport).quote(this.name), new Object[0]);
    }

    @Override
    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP USER " + ((OracleDbSupport)this.dbSupport).quote(this.name) + " CASCADE", new Object[0]);
    }

    @Override
    protected void doClean() throws SQLException {
        Map<String, List<String>> objectsByType;
        if (this.isSystem()) {
            throw new FlywayException("Clean not supported on Oracle for system schema " + ((OracleDbSupport)this.dbSupport).quote(this.name) + "! " + "It must not be changed in any way except by running an Oracle-supplied script!");
        }
        if (((OracleDbSupport)this.dbSupport).isFlashbackDataArchiveAvailable()) {
            this.disableFlashbackArchiveForFbaTrackedTables();
        }
        if (((OracleDbSupport)this.dbSupport).isLocatorAvailable()) {
            this.cleanLocatorMetadata();
        }
        if ((objectsByType = this.getObjectsGroupedByType()).containsKey("TRIGGER")) {
            for (String statement : this.generateDropStatementsForObjectType("TRIGGER", "", objectsByType.get("TRIGGER"))) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (objectsByType.containsKey("TABLE")) {
            for (String statement : this.generateDropStatementsForQueueTables()) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (objectsByType.containsKey("JOB")) {
            for (String statement : this.generateDropStatementsForSchedulerJobs(objectsByType.get("JOB"))) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (objectsByType.containsKey("MATERIALIZED VIEW")) {
            for (String statement : this.generateDropStatementsForObjectType("MATERIALIZED VIEW", "PRESERVE TABLE", objectsByType.get("MATERIALIZED VIEW"))) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (objectsByType.containsKey("TABLE")) {
            for (String statement : this.generateDropStatementsForMaterializedViewLogs()) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (objectsByType.containsKey("VIEW")) {
            for (String statement : this.generateDropStatementsForObjectType("VIEW", "CASCADE CONSTRAINTS")) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (objectsByType.containsKey("INDEX")) {
            for (String statement : this.generateDropStatementsForDomainIndexes()) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (objectsByType.containsKey("TABLE")) {
            for (String statement : this.generateDropStatementsForXmlTables()) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (objectsByType.containsKey("TABLE")) {
            for (Table table : this.allTables()) {
                table.drop();
            }
        }
        if (objectsByType.containsKey("INDEX")) {
            for (String statement : this.generateDropStatementsForNonDomainIndexes()) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (objectsByType.containsKey("CLUSTER")) {
            for (String statement : this.generateDropStatementsForObjectType("CLUSTER", "INCLUDING TABLES CASCADE CONSTRAINTS", objectsByType.get("CLUSTER"))) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (objectsByType.containsKey("SEQUENCE")) {
            for (String statement : this.generateDropStatementsForObjectType("SEQUENCE", "")) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (objectsByType.containsKey("FUNCTION")) {
            for (String statement : this.generateDropStatementsForObjectType("FUNCTION", "", objectsByType.get("FUNCTION"))) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (objectsByType.containsKey("PROCEDURE")) {
            for (String statement : this.generateDropStatementsForObjectType("PROCEDURE", "", objectsByType.get("PROCEDURE"))) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (objectsByType.containsKey("PACKAGE")) {
            for (String statement : this.generateDropStatementsForObjectType("PACKAGE", "", objectsByType.get("PACKAGE"))) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (objectsByType.containsKey("TYPE")) {
            for (String statement : this.generateDropStatementsForObjectType("TYPE", "FORCE")) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (objectsByType.containsKey("SYNONYM")) {
            for (String statement : this.generateDropStatementsForObjectType("SYNONYM", "FORCE", objectsByType.get("SYNONYM"))) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (objectsByType.containsKey("JAVA SOURCE")) {
            for (String statement : this.generateDropStatementsForObjectType("JAVA SOURCE", "", objectsByType.get("JAVA SOURCE"))) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (this.isDefaultSchemaForUser()) {
            this.jdbcTemplate.execute("PURGE RECYCLEBIN", new Object[0]);
        }
    }

    private Map<String, List<String>> getObjectsGroupedByType() throws SQLException {
        boolean xmlDbAvailable = ((OracleDbSupport)this.dbSupport).isXmlDbAvailable();
        String query = "SELECT OBJECT_TYPE, OBJECT_NAME FROM ALL_OBJECTS WHERE OWNER = ? " + (xmlDbAvailable ? "UNION ALL SELECT 'TABLE', TABLE_NAME FROM ALL_XML_TABLES WHERE OWNER = ? AND TABLE_NAME NOT LIKE 'BIN$________________________$_'" : "");
        int n = 1;
        if (xmlDbAvailable) {
            ++n;
        }
        Object[] params = new String[n];
        Arrays.fill(params, this.name);
        List<Map<String, String>> rows = this.jdbcTemplate.queryForList(query, (String[])params);
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Map<String, String> row : rows) {
            String objectType = row.get("OBJECT_TYPE");
            String objectName = row.get("OBJECT_NAME");
            if (result.containsKey(objectType)) {
                ((List)result.get(objectType)).add(objectName);
                continue;
            }
            ArrayList<String> newList = new ArrayList<String>();
            newList.add(objectName);
            result.put(objectType, newList);
        }
        return result;
    }

    private void disableFlashbackArchiveForFbaTrackedTables() throws SQLException {
        String queryForFbaTrackedTables = "SELECT TABLE_NAME FROM DBA_FLASHBACK_ARCHIVE_TABLES WHERE OWNER_NAME = ?";
        List<String> tableNames = this.jdbcTemplate.queryForStringList(queryForFbaTrackedTables, this.name);
        for (String tableName : tableNames) {
            this.jdbcTemplate.execute("ALTER TABLE " + ((OracleDbSupport)this.dbSupport).quote(this.name, tableName) + " NO FLASHBACK ARCHIVE", new Object[0]);
            while (((OracleDbSupport)this.dbSupport).queryReturnsRows(queryForFbaTrackedTables + " AND TABLE_NAME = ?", this.name, tableName)) {
                try {
                    LOG.debug("Actively waiting for Flashback cleanup on table: " + ((OracleDbSupport)this.dbSupport).quote(this.name, tableName));
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new FlywayException("Waiting for Flashback cleanup interrupted", e);
                }
            }
        }
    }

    private boolean locatorMetadataExists() throws SQLException {
        return ((OracleDbSupport)this.dbSupport).queryReturnsRows("SELECT * FROM ALL_SDO_GEOM_METADATA WHERE OWNER = ?", this.name);
    }

    private void cleanLocatorMetadata() throws SQLException {
        if (!this.locatorMetadataExists()) {
            return;
        }
        if (!this.isDefaultSchemaForUser()) {
            LOG.warn("Unable to clean Oracle Locator metadata for schema " + ((OracleDbSupport)this.dbSupport).quote(this.name) + " by user \"" + ((OracleDbSupport)this.dbSupport).getCurrentUserName() + "\": unsupported operation");
            return;
        }
        this.jdbcTemplate.getConnection().commit();
        this.jdbcTemplate.execute("DELETE FROM USER_SDO_GEOM_METADATA", new Object[0]);
        this.jdbcTemplate.getConnection().commit();
    }

    private String generateDefaultDropStatement(String typeName, String objectName, String dropOptions) {
        return "DROP " + typeName + " " + ((OracleDbSupport)this.dbSupport).quote(this.name, objectName) + " " + (StringUtils.hasText(dropOptions) ? dropOptions : "");
    }

    private List<String> getObjectsByType(String typeName) throws SQLException {
        return this.jdbcTemplate.queryForStringList("SELECT OBJECT_NAME FROM ALL_OBJECTS WHERE OWNER = ? AND OBJECT_TYPE = ?", this.name, typeName);
    }

    private List<String> generateDropStatementsForObjectType(String typeName, String dropOptions) throws SQLException {
        return this.generateDropStatementsForObjectType(typeName, dropOptions, this.getObjectsByType(typeName));
    }

    private List<String> generateDropStatementsForObjectType(String typeName, String dropOptions, List<String> prefetchedObjects) throws SQLException {
        ArrayList<String> dropStatements = new ArrayList<String>();
        for (String objectName : prefetchedObjects) {
            dropStatements.add(this.generateDefaultDropStatement(typeName, objectName, dropOptions));
        }
        return dropStatements;
    }

    private List<String> generateDropStatementsForQueueTables() throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        List<String> objectNames = this.jdbcTemplate.queryForStringList("SELECT QUEUE_TABLE FROM ALL_QUEUE_TABLES WHERE OWNER = ?", this.name);
        for (String objectName : objectNames) {
            statements.add("BEGIN DBMS_AQADM.DROP_QUEUE_TABLE('" + ((OracleDbSupport)this.dbSupport).quote(this.name, objectName) + "', FORCE => TRUE); END;");
        }
        return statements;
    }

    private List<String> generateDropStatementsForSchedulerJobs() throws SQLException {
        return this.generateDropStatementsForSchedulerJobs(this.getObjectsByType("JOB"));
    }

    private List<String> generateDropStatementsForSchedulerJobs(List<String> prefetchedObjects) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        for (String objectName : prefetchedObjects) {
            statements.add("BEGIN DBMS_SCHEDULER.DROP_JOB('" + ((OracleDbSupport)this.dbSupport).quote(this.name, objectName) + "', FORCE => TRUE); END;");
        }
        return statements;
    }

    private List<String> generateDropStatementsForMaterializedViewLogs() throws SQLException {
        ArrayList<String> dropStatements = new ArrayList<String>();
        List<String> objectNames = this.jdbcTemplate.queryForStringList("SELECT MASTER FROM ALL_MVIEW_LOGS WHERE LOG_OWNER = ?", this.name);
        for (String objectName : objectNames) {
            dropStatements.add(this.generateDefaultDropStatement("MATERIALIZED VIEW LOG ON", objectName, ""));
        }
        return dropStatements;
    }

    private List<String> generateDropStatementsForDomainIndexes() throws SQLException {
        ArrayList<String> dropStatements = new ArrayList<String>();
        List<String> objectNames = this.jdbcTemplate.queryForStringList("SELECT INDEX_NAME FROM ALL_INDEXES WHERE OWNER = ? AND INDEX_TYPE LIKE '%DOMAIN%'", this.name);
        for (String objectName : objectNames) {
            dropStatements.add(this.generateDefaultDropStatement("INDEX", objectName, "FORCE"));
        }
        return dropStatements;
    }

    private List<String> generateDropStatementsForNonDomainIndexes() throws SQLException {
        ArrayList<String> dropStatements = new ArrayList<String>();
        List<String> objectNames = this.jdbcTemplate.queryForStringList("SELECT INDEX_NAME FROM ALL_INDEXES WHERE OWNER = ? AND INDEX_TYPE NOT LIKE '%DOMAIN%'", this.name);
        for (String objectName : objectNames) {
            dropStatements.add(this.generateDefaultDropStatement("INDEX", objectName, ""));
        }
        return dropStatements;
    }

    private List<String> generateDropStatementsForXmlTables() throws SQLException {
        ArrayList<String> dropStatements = new ArrayList<String>();
        List<String> objectNames = ((OracleDbSupport)this.dbSupport).isXmlDbAvailable() ? this.jdbcTemplate.queryForStringList("SELECT TABLE_NAME FROM ALL_XML_TABLES WHERE OWNER = ? AND TABLE_NAME NOT LIKE 'BIN$________________________$_'", this.name) : Collections.emptyList();
        for (String objectName : objectNames) {
            dropStatements.add(this.generateDefaultDropStatement("TABLE", objectName, "CASCADE CONSTRAINTS PURGE"));
        }
        return dropStatements;
    }

    @Override
    protected Table[] doAllTables() throws SQLException {
        String tablesQuery = "SELECT TABLE_NAME, OWNER\nFROM ALL_TABLES\nWHERE OWNER = ?\n  AND (IOT_TYPE IS NULL OR IOT_TYPE NOT LIKE '%OVERFLOW%')\n  AND NESTED != 'YES'\n  AND SECONDARY != 'Y'\n";
        boolean referencePartitionedTablesExist = ((OracleDbSupport)this.dbSupport).queryReturnsRows("SELECT * FROM ALL_PART_TABLES WHERE OWNER = ? AND PARTITIONING_TYPE = 'REFERENCE'", this.name);
        if (referencePartitionedTablesExist) {
            tablesQuery = "WITH TABLES AS (\n" + tablesQuery + ")\n" + "SELECT t.TABLE_NAME\n" + "FROM TABLES t\n" + "  LEFT JOIN ALL_PART_TABLES pt\n" + "    ON t.OWNER = pt.OWNER\n" + "   AND t.TABLE_NAME = pt.TABLE_NAME\n" + "   AND pt.PARTITIONING_TYPE = 'REFERENCE'\n" + "  LEFT JOIN ALL_CONSTRAINTS fk\n" + "    ON pt.OWNER = fk.OWNER\n" + "   AND pt.TABLE_NAME = fk.TABLE_NAME\n" + "   AND pt.REF_PTN_CONSTRAINT_NAME = fk.CONSTRAINT_NAME\n" + "   AND fk.CONSTRAINT_TYPE = 'R'\n" + "  LEFT JOIN ALL_CONSTRAINTS puk\n" + "    ON fk.R_OWNER = puk.OWNER\n" + "   AND fk.R_CONSTRAINT_NAME = puk.CONSTRAINT_NAME\n" + "   AND puk.CONSTRAINT_TYPE IN ('P', 'U')\n" + "  LEFT JOIN TABLES p\n" + "    ON puk.OWNER = p.OWNER\n" + "   AND puk.TABLE_NAME = p.TABLE_NAME\n" + "START WITH p.TABLE_NAME IS NULL\n" + "CONNECT BY PRIOR t.TABLE_NAME = p.TABLE_NAME\n" + "ORDER BY LEVEL DESC";
        }
        List<String> tableNames = this.jdbcTemplate.queryForStringList(tablesQuery, this.name);
        Table[] tables = new Table[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new OracleTable(this.jdbcTemplate, this.dbSupport, this, tableNames.get(i));
        }
        return tables;
    }

    @Override
    public Table getTable(String tableName) {
        return new OracleTable(this.jdbcTemplate, this.dbSupport, this, tableName);
    }
}

