/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util;

import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.util.TransactionWork;
import java.util.HashSet;
import java.util.Set;

public interface TransactionRetryStrategy<T> {
    public T execute(TransactionalGraph var1, TransactionWork<T> var2);

    public static abstract class AbstractRetryStrategy<T>
    implements TransactionRetryStrategy<T> {
        public static final int DEFAULT_TRIES = 8;
        protected final int tries;
        protected final Set<Class> exceptionsToRetryOn;

        public AbstractRetryStrategy() {
            this(8, new HashSet<Class>());
        }

        public AbstractRetryStrategy(int tries, Set<Class> exceptionsToRetryOn) {
            this.tries = tries;
            this.exceptionsToRetryOn = exceptionsToRetryOn;
        }

        abstract long getDelay(int var1);

        @Override
        public T execute(TransactionalGraph graph, TransactionWork<T> work) {
            Exception previousException = new RuntimeException("Exception initialized when trying commit.");
            for (int ix = 0; ix < this.tries; ++ix) {
                if (ix > 0) {
                    try {
                        Thread.sleep(this.getDelay(ix));
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                try {
                    T returnValue = work.execute(graph);
                    graph.commit();
                    return returnValue;
                }
                catch (Exception ex) {
                    graph.rollback();
                    boolean retry = false;
                    if (this.exceptionsToRetryOn.size() == 0) {
                        retry = true;
                    } else {
                        for (Class exceptionToRetryOn : this.exceptionsToRetryOn) {
                            if (!ex.getClass().equals(exceptionToRetryOn)) continue;
                            retry = true;
                            break;
                        }
                    }
                    if (!retry) {
                        throw new RuntimeException(ex);
                    }
                    previousException = ex;
                    continue;
                }
            }
            throw new RuntimeException(previousException);
        }
    }

    public static class ExponentialBackoff<T>
    extends AbstractRetryStrategy<T> {
        public static final long DEFAULT_DELAY_MS = 20L;
        private final long initialDelay;

        public ExponentialBackoff() {
            this(8, 20L);
        }

        public ExponentialBackoff(int tries, long initialDelay) {
            this(tries, initialDelay, new HashSet<Class>());
        }

        public ExponentialBackoff(int tries, long initialDelay, Set<Class> exceptionsToRetryOn) {
            super(tries, exceptionsToRetryOn);
            this.initialDelay = initialDelay;
        }

        @Override
        long getDelay(int retryCount) {
            return (long)((double)this.initialDelay * Math.pow(2.0, retryCount));
        }
    }

    public static class DelayedRetry<T>
    extends AbstractRetryStrategy<T> {
        public static final long DEFAULT_DELAY_MS = 20L;
        private final long delayBetweenRetry;

        public DelayedRetry() {
            this(8, 20L);
        }

        public DelayedRetry(int tries, long delayBetweenRetry) {
            this(tries, delayBetweenRetry, new HashSet<Class>());
        }

        public DelayedRetry(int tries, long delayBetweenRetry, Set<Class> exceptionsToRetryOn) {
            super(tries, exceptionsToRetryOn);
            this.delayBetweenRetry = delayBetweenRetry;
        }

        @Override
        long getDelay(int retryCount) {
            return this.delayBetweenRetry;
        }
    }

    public static class FireAndForget<T>
    implements TransactionRetryStrategy<T> {
        @Override
        public T execute(TransactionalGraph graph, TransactionWork<T> work) {
            T returnValue = null;
            try {
                returnValue = work.execute(graph);
                graph.commit();
            }
            catch (Exception e) {
                graph.rollback();
            }
            return returnValue;
        }
    }

    public static class OneAndDone<T>
    implements TransactionRetryStrategy<T> {
        @Override
        public T execute(TransactionalGraph graph, TransactionWork<T> work) {
            T returnValue;
            try {
                returnValue = work.execute(graph);
                graph.commit();
            }
            catch (Exception e) {
                graph.rollback();
                throw new RuntimeException(e);
            }
            return returnValue;
        }
    }
}

