/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema.clusterselection;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionStrategy;
import com.orientechnologies.orient.core.record.impl.ODocument;

public class OBalancedClusterSelectionStrategy
implements OClusterSelectionStrategy {
    public static final String NAME = "balanced";
    protected static final long REFRESH_TIMEOUT = 5000L;
    protected long lastCount = -1L;
    protected int smallerClusterId = -1;

    @Override
    public int getCluster(OClass iClass, ODocument doc) {
        int[] clusters = iClass.getClusterIds();
        if (clusters.length == 1) {
            return clusters[0];
        }
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db == null) {
            return clusters[0];
        }
        if (this.lastCount < 0L || System.currentTimeMillis() - this.lastCount > 5000L) {
            long min = Long.MAX_VALUE;
            for (int cluster : clusters) {
                long count = db.countClusterElements(cluster);
                if (count >= min) continue;
                min = count;
                this.smallerClusterId = cluster;
            }
            this.lastCount = System.currentTimeMillis();
        }
        return this.smallerClusterId;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

